<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Traverser;

use Magento\Mray\CodeStructuralElement\Php\Usage\UsageCase;
use Magento\Mray\Index\IsCoreDependency;
use Magento\Mray\MagentoApiIndex\Index\Version;
use Magento\Mray\Package\AbstractTree\Component\MagentoModule;
use Magento\Mray\Package\AbstractTree\Node\Node;

class DiXmlUsageDiscovery implements NodeVisitor
{
    /**
     * @var Version
     */
    private $index;

    /**
     * @var IsCoreDependency
     */
    private $isCoreDependency;

    /**
     * @param Version $index
     * @param IsCoreDependency $isCoreDependency
     */
    public function __construct(
        Version $index,
        IsCoreDependency $isCoreDependency
    ) {
        $this->index = $index;
        $this->isCoreDependency = $isCoreDependency;
    }

    /**
     * @inheritDoc
     */
    public function leaveNode(Node $node)
    {
        if (!$node instanceof MagentoModule) {
            return null;
        }

        if (!isset($node->attributes['diXmlDeclarations']) || !is_array($node->attributes['diXmlDeclarations'])) {
            return null;
        }

        $dependencies = $node->getAttribute('dependencies') ?? [];

        foreach ($node->attributes['diXmlDeclarations'] as $diXmlFileDeclarations) {
            /** @var UsageCase $diXmlDeclaration */
            foreach ($diXmlFileDeclarations as $diXmlDeclaration) {
                if ($diXmlDeclaration->getHow() === 'virtual-type-name') {
                    continue;
                }
                if ($this->isCoreDependency->execute($diXmlDeclaration->getWhat(), $this->index->magentoVersion())) {
                    if (!isset($dependencies[$diXmlDeclaration->getWhat()])) {
                        $dependencies[$diXmlDeclaration->getWhat()] = [
                            'type' => 'class',
                            'realName' => $diXmlDeclaration->getWhat(),
                            'usage' => [
                                'reference' => [
                                    $diXmlDeclaration->describe()
                                ]
                            ]
                        ];
                        continue;
                    }
                    $dependencies[$diXmlDeclaration->getWhat()]['usage']['reference'][] = $diXmlDeclaration->describe();
                }
            }
        }

        $node->setAttribute('dependencies', $dependencies);
    }

    /**
     * @param  Node $node
     * @return null
     */
    public function enterNode(Node $node)
    {
        return null;
    }
}
