<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Traverser;

use Magento\Mray\Index\Collection\MagentoComponents;
use Magento\Mray\Package\AbstractTree\Component\MagentoProject;
use Magento\Mray\Package\AbstractTree\Node\Component;
use Magento\Mray\Package\AbstractTree\Component\MagentoEcosystemAsset;
use Magento\Mray\Package\AbstractTree\Node\Node;

class MagentoComponentsDiscovery implements NodeVisitor
{
    /**
     * @var MagentoComponents
     */
    private $components;

    /**
     * @param MagentoComponents $components
     */
    public function __construct(MagentoComponents $components)
    {
        $this->components = $components;
    }

    /**
     * @inheritDoc
     */
    public function enterNode(Node $node)
    {
        if ($node instanceof MagentoProject) {
            return;
        }
        if ($node instanceof Component && $node instanceof MagentoEcosystemAsset) {
            $this->components->register($node);
        }
    }

    /**
     * @inheritDoc
     */
    public function leaveNode(Node $node)
    {
        return null;
    }
}
