<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Traverser;

use Magento\Mray\Package\AbstractTree\Node\Node;
use Magento\Mray\Index\Collection\DbSchema;
use Magento\Mray\Parse\Xml\XMLStringToAssocArray;

class MagentoDbSchemaDiscovery implements NodeVisitor
{
    /**
     * @var DbSchema
     */
    private $dbSchemaCollection;

    /**
     * @var XMLStringToAssocArray
     */
    private $convertDbSchema;

    /**
     * @param DbSchema $dbSchemaCollection
     */
    public function __construct(DbSchema $dbSchemaCollection)
    {
        $this->dbSchemaCollection = $dbSchemaCollection;
        $this->convertDbSchema = new XMLStringToAssocArray();
    }

    /**
     * @inheritDoc
     */
    public function enterNode(Node $node)
    {
        if (!isset($node->attributes['dbSchema']) || !is_array($node->attributes['dbSchema'])) {
            return null;
        }
        foreach ($node->attributes['dbSchema'] as $data) {
            $this->dbSchemaCollection->register($this->convertDbSchema->execute($data));
        }
    }

    /**
     * @param Node $node
     * @return null
     */
    public function leaveNode(Node $node)
    {
        return null;
    }
}
