<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Traverser;

use Magento\Mray\Index\Collection\VirtualTypes;
use Magento\Mray\Index\Scanner\Probe\MagentoModule;
use Magento\Mray\Package\AbstractTree\Component\MagentoProject;
use Magento\Mray\Package\AbstractTree\Node\Node;
use Magento\Mray\Package\AbstractTree\Node\Package;

class MagentoVirtualTypesDiscovery implements NodeVisitor
{
    /**
     * @var VirtualTypes $virtualTypesCollection
     */
    private $virtualTypesCollection;

    /**
     * @param VirtualTypes $virtualTypesCollection
     */
    public function __construct(VirtualTypes $virtualTypesCollection)
    {
        $this->virtualTypesCollection = $virtualTypesCollection;
    }
    /**
     * @inheritDoc
     */
    public function enterNode(Node $node)
    {
        if (isset($node->attributes["diXmlDeclarations"]) && is_array($node->attributes["diXmlDeclarations"])) {
            foreach ($node->attributes["diXmlDeclarations"] as $diXmlDeclarations) {
                foreach ($diXmlDeclarations as $diXmlDeclaration) {
                    if ($diXmlDeclaration->getHow() === "virtual-type-name") {
                        $this->virtualTypesCollection->register($diXmlDeclaration->getWhat());
                    }
                }
            }
        }
    }

    /**
     * @param Node $node
     * @return null
     */
    public function leaveNode(Node $node)
    {
        return null;
    }
}
