<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Traverser;

use Magento\Mray\Package\AbstractTree\Node\Node;

/**
 * Inspired by PhpParser\NodeVisitor
 */
interface NodeVisitor
{
    /**
     * @param Node $node
     * @return null - for future improvement and modification of tree during traverse
     */
    public function enterNode(Node $node);

    /**
     * @param Node $node
     * @return mixed - for future improvement and modification of tree during traverse
     */
    public function leaveNode(Node $node);
}
