<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Traverser\PhpCodeUsageFilter;

use Magento\Mray\Index\IsCoreDependency;
use Magento\Mray\Index\Traverser\PhpCodeUsageFilterInterface;

class CustomProjectCodeUsageFilter implements PhpCodeUsageFilterInterface
{
    /**
     * @var IsCoreDependency
     */
    private $isCoreDependency;

    /**
     * @param IsCoreDependency $isCoreDependency
     */
    public function __construct(IsCoreDependency $isCoreDependency)
    {
        $this->isCoreDependency = $isCoreDependency;
    }

    /**
     * @param string $usage
     * @param string $version
     * @return bool
     */
    public function filter(string $usage, string $version): bool
    {
        $topLevelElement = explode('::', $usage, 2)[0];
        return $this->isCoreDependency->execute($topLevelElement, $version);
    }
}
