<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Index\Traverser\PhpCodeUsageFilter;

use Magento\Mray\CodeStructuralElement\Php\Reflection\Context\StructuralElementDeclarations;
use Magento\Mray\CodeStructuralElement\Php\Reflection\InCodeDeclaration;
use Magento\Mray\Index\Traverser\PhpCodeUsageFilterInterface;

class ExtensionCodeUsageFilter implements PhpCodeUsageFilterInterface
{
    /**
     * @var StructuralElementDeclarations
     */
    private $phpElementsRegistry;

    /**
     * @param StructuralElementDeclarations $phpElementsRegistry
     */
    public function __construct(
        StructuralElementDeclarations $phpElementsRegistry
    ) {
        $this->phpElementsRegistry = $phpElementsRegistry;
    }

    /**
     * @param string $usage
     * @return bool
     */
    public function filter(string $usage): bool
    {
        $topLevelElement = explode('::', $usage, 2)[0];
        $declaration = $this->phpElementsRegistry->findClassLike($topLevelElement)
            ?: $this->phpElementsRegistry->findFunction($topLevelElement)
            ?: $this->phpElementsRegistry->findGlobalConstant($topLevelElement);
        if (!$declaration) {
            return true;
        }
        return !$declaration instanceof InCodeDeclaration;
    }
}
