<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Component;

use Magento\Mray\Package\AbstractTree\Node\Component;
use Magento\Mray\Package\AbstractTree\Node\Identifier;
use Magento\Mray\Package\AbstractTree\Node\PackageReference;

class MagentoTheme extends Component implements MagentoEcosystemAsset
{
    /** @var PackageReference|null  */
    public $parent;

    /**
     * @param Identifier $identifier
     * @param mixed $parent
     */
    public function __construct(
        Identifier $identifier,
        $parent
    ) {
        parent::__construct($identifier);

        if (!$parent) {
            $this->parent = null;
        } elseif ($parent instanceof PackageReference) {
            $this->parent = $parent;
        } elseif ($parent instanceof Identifier) {
            $this->parent = new PackageReference($parent);
        } else {
            $this->parent = new PackageReference(new Identifier\Named((string)$parent));
        }
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Pkg_MagentoTheme';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return array_merge(parent::getSubNodeNames(), [
            'parent'
        ]);
    }
}
