<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Component;

use Magento\Mray\Package\AbstractTree\Node\Component;
use Magento\Mray\Package\AbstractTree\ComponentHolder;
use Magento\Mray\Package\AbstractTree\ComponentHolderOperations;

class Project extends Component implements ComponentHolder
{
    use ComponentHolderOperations;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Pkg_Project';
    }

    /**
     * @return array
     */
    public function getSubNodeNames(): array
    {
        return array_merge(parent::getSubNodeNames(), [
            'components',
        ]);
    }
}
