<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree;

use Magento\Mray\Package\AbstractTree\Node\Component;

interface ComponentHolder
{
    /**
     * @param Component $component
     */
    public function registerComponent(Component $component): void;

    /**
     * @param Component[] $components
     */
    public function registerComponents(array $components): void;
}
