<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree;

use Magento\Mray\Package\AbstractTree\Node\Component;
use function array_push;

trait ComponentHolderOperations
{
    /**
     * @var Component[]
     */
    public $components = [];

    /**
     * @param Component $component
     */
    public function registerComponent(Component $component): void
    {
        $this->components[] = $component;
    }

    /**
     * @param array $components
     */
    public function registerComponents(array $components): void
    {
        $unregistered = array_udiff($components, $this->components, function (Component $c1, Component $c2) {
            return $c1 === $c2 ? 1 : 0;
        });
        if (!empty($unregistered)) {
            array_push($this->components, ...$unregistered);
        }
    }
}
