<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\DistributionPackage;

use Magento\Mray\Package\AbstractTree\Node\ComposerTypeReference;
use Magento\Mray\Package\AbstractTree\Node\DistributionPackage;
use Magento\Mray\Package\AbstractTree\Node\Identifier;
use function array_map;

class Composer extends DistributionPackage
{
    /** @var ComposerTypeReference  */
    public $type;

    /** @var array */
    public $namespaces;

    /**
     * @param Identifier $identifier
     * @param mixed $type
     * @param array $namespaces
     */
    public function __construct(
        Identifier $identifier,
        $type,
        array $namespaces
    ) {
        parent::__construct($identifier);
        $this->type = $type instanceof ComposerTypeReference ? $type : new ComposerTypeReference((string)$type);
        $this->namespaces = array_map(function (string $ns) {
            return $ns;
        }, $namespaces);
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Pkg_Composer';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return array_merge(parent::getSubNodeNames(), [
            'type'
        ]);
    }
}
