<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Identifier;

use Magento\Mray\Package\AbstractTree\Node\NodeAbstract;
use Magento\Mray\Package\AbstractTree\Node\Identifier;
use Magento\Mray\Package\AbstractTree\Node\VendorReference;
use function sprintf;

class ComposerPackage extends NodeAbstract implements Identifier
{
    /** @var string */
    public $name;
    /** @var VendorReference  */
    public $vendor;

    /**
     * @param string $name
     * @param string $vendor
     */
    public function __construct(string $name, string $vendor)
    {
        $this->name = $name;
        $this->vendor = $vendor instanceof VendorReference ? $vendor : new VendorReference((string)$vendor);
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return sprintf('%s/%s', $this->vendor, $this->name);
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Id_ComposerPkg';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [
            'vendor',
        ];
    }
}
