<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Identifier;

use Magento\Mray\Package\AbstractTree\Node\MagentoAreaReference;
use Magento\Mray\Package\AbstractTree\Node\NodeAbstract;
use Magento\Mray\Package\AbstractTree\Node\Identifier;
use Magento\Mray\Package\AbstractTree\Node\VendorReference;
use function sprintf;

class MagentoTheme extends NodeAbstract implements Identifier
{
    /** @var MagentoAreaReference|null  */
    public $area;
    /** @var VendorReference  */
    public $vendor;
    /** @var string  */
    public $name;

    /**
     * @param string $name
     * @param mixed $vendor
     * @param mixed $area
     */
    public function __construct(string $name, $vendor, $area)
    {
        $this->name = $name;
        $this->vendor = $vendor instanceof VendorReference ? $vendor : new VendorReference((string)$vendor);

        if (!$area) {
            $this->area = null;
        } elseif ($area instanceof MagentoAreaReference) {
            $this->area = $area;
        } else {
            $this->area = new MagentoAreaReference($area);
        }
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        $id = sprintf('%s/%s', $this->vendor, $this->name);
        if ($this->area) {
            $id = sprintf('%s/%s', $this->area, $id);
        }
        return $id;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Id_MagentoTheme';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [
            'vendor',
            'area',
        ];
    }
}
