<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Identifier;

use Magento\Mray\Package\AbstractTree\Node\NodeAbstract;
use Magento\Mray\Package\AbstractTree\Node\Identifier;

class Named extends NodeAbstract implements Identifier
{
    /** @var string  */
    public $value;

    /**
     * @param string $value
     */
    public function __construct(string $value)
    {
        $this->value = $value;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Id_Versioned';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [

        ];
    }
}
