<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Identifier;

use Magento\Mray\Package\AbstractTree\Node\NodeAbstract;
use Magento\Mray\Package\AbstractTree\Node\Identifier;
use Magento\Mray\Package\AbstractTree\Node\Version;
use function sprintf;

class Versioned extends NodeAbstract implements Identifier
{
    /** @var Identifier  */
    public $identifier;
    /** @var Version  */
    public $version;

    /**
     * @param Identifier $identifier
     * @param Version $version
     */
    public function __construct(Identifier $identifier, Version $version)
    {
        $this->identifier = $identifier;
        $this->version = $version;
    }

    /**
     * @return Identifier
     */
    public function getIdentifier(): Identifier
    {
        return $this->identifier;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return sprintf('%s@%s', $this->identifier->__toString(), $this->version->__toString());
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Id_Versioned';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [
            'identifier',
            'version',
        ];
    }
}
