<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

class Component extends NodeAbstract implements Package
{
    use NodeAttributes;

    /** @var Identifier  */
    public $identifier;

    /**
     * @param Identifier $identifier
     */
    public function __construct(Identifier $identifier)
    {
        $this->identifier = $identifier;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Pkg_Component';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [
            'identifier',
        ];
    }
}
