<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

use Magento\Mray\Package\AbstractTree\ComponentHolder;
use Magento\Mray\Package\AbstractTree\ComponentHolderOperations;

class DistributionPackage extends NodeAbstract implements Package, ComponentHolder
{
    use NodeAttributes;
    use ComponentHolderOperations;

    public const COMPONENT = 1; // distribution package is a component
    public const CONTAINER = 2; // distribution package is a container for multiple components

    /** @var Identifier */
    public $identifier;

    /** @var int */
    public $flags = 0;

    /**
     * @param Identifier $identifier
     */
    public function __construct(Identifier $identifier)
    {
        $this->identifier = $identifier;
    }

    /**
     * @return Identifier
     */
    public function getIdentifier(): Identifier
    {
        return $this->identifier;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Pkg_Distribution';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [
            'identifier',
            'components',
        ];
    }

    /**
     * Put flag as component.
     */
    public function markAsComponent(): void
    {
        $this->flags |= self::COMPONENT;
    }

    /**
     * Put flag as container.
     */
    public function markAsContainer(): void
    {
        $this->flags |= self::CONTAINER;
    }

    /**
     * @return bool
     */
    public function isComponent(): bool
    {
        return (bool)($this->flags & self::COMPONENT);
    }

    /**
     * @return bool
     */
    public function isContainer(): bool
    {
        return (bool)($this->flags & self::CONTAINER);
    }
}
