<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

class MagentoAreaReference extends NodeAbstract
{
    /** @var string  */
    public $name;

    /**
     * @param string $name
     */
    public function __construct(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Ref_MagentoArea';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [

        ];
    }
}
