<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

use function array_key_exists;

trait NodeAttributes
{
    /** @var array  */
    public $attributes = [];

    /**
     * @param string $attr
     * @return bool
     */
    public function hasAttribute(string $attr): bool
    {
        return array_key_exists($attr, $this->attributes);
    }

    /**
     * @param string $attr
     * @param mixed $value
     */
    public function setAttribute(string $attr, $value): void
    {
        $this->attributes[$attr] = $value;
    }

    /**
     * @param string $attr
     * @return mixed|null
     */
    public function getAttribute(string $attr)
    {
        return $this->attributes[$attr] ?? null;
    }

    /**
     * @param string $attr
     */
    public function unsetAttribute(string $attr): void
    {
        unset($this->attributes[$attr]);
    }
}
