<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

use function get_object_vars;

trait NodeSerialization
{
    /**
     * @return array
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        $data = ['nodeType' => $this->getType()] + get_object_vars($this);
        if (isset($data['attributes']) && empty($data['attributes'])) {
            unset($data['attributes']);
        }
        return $data;
    }

    /**
     * @return string
     */
    abstract public function getType(): string;
}
