<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

interface NodeWithAttributes
{
    /**
     * @param string $attr
     * @return bool
     */
    public function hasAttribute(string $attr): bool;

    /**
     * @param string $attr
     * @param mixed $value
     */
    public function setAttribute(string $attr, $value): void;

    /**
     * @param string $attr
     * @return mixed
     */
    public function getAttribute(string $attr);

    /**
     * @param string $attr
     */
    public function unsetAttribute(string $attr): void;
}
