<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

use function array_map;

class PhpCode extends NodeAbstract implements NodeWithAttributes
{
    use NodeAttributes;

    /**
     * @var PhpFile[]
     */
    public $files;

    /**
     * @var array|null
     */
    private $declarations;

    /**
     * @param array $files
     */
    public function __construct(array $files)
    {
        $this->files = array_map(function (PhpFile $f) {
            return $f;
        }, $files);
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'Code_Php';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [
            'files'
        ];
    }

    /**
     * @return array|null
     */
    public function getDeclarations(): ?array
    {
        return $this->declarations;
    }

    /**
     * @param array $declarations
     */
    public function setDeclarations(array $declarations)
    {
        $this->declarations = $declarations;
    }
}
