<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Node;

use PhpParser\Node as PhpNode;
use PhpParser\Error as PhpSyntaxError;
use function array_map;

class PhpFile extends NodeAbstract implements NodeWithAttributes
{
    use NodeAttributes;

    /** @var string  */
    public $file;
    /** @var PhpNode[] */
    public $ast;

    /** @var PhpSyntaxError[] */
    public $syntaxErrs;

    /**
     * @var array|null
     */
    private $declarations;

    /**
     * @param string $file
     * @param array $ast
     * @param array $syntaxErrs
     */
    public function __construct(string $file, array $ast, array $syntaxErrs)
    {
        $this->file = $file;
        $this->ast = array_map(function (PhpNode $n) {
            return $n;
        }, $ast);
        $this->syntaxErrs = array_map(function (PhpSyntaxError $e) {
            return $e;
        }, $syntaxErrs);
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'File_Php';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [
            'file',
            'ast',
            'syntaxErrs'
        ];
    }

    /**
     * @return array|null
     */
    public function getDeclarations(): ?array
    {
        return $this->declarations;
    }

    /**
     * @param array $declarations
     */
    public function setDeclarations(array $declarations)
    {
        $this->declarations = $declarations;
    }
}
