<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree;

interface ScannerSubject
{
    /**
     * @return string
     */
    public function location(): string;

    /**
     * @param string $relativePath
     * @return bool
     */
    public function contains(string $relativePath): bool;

    /**
     * @param string $relativePath
     * @param ScannerSubjectReader $reader
     * @return mixed
     */
    public function read(string $relativePath, ScannerSubjectReader $reader);

    /**
     * @return ScannerSubject[]
     */
    public function fragments(): iterable;
}
