<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Package\AbstractTree\Version;

use Magento\Mray\Package\AbstractTree\Node\NodeAbstract;
use Magento\Mray\Package\AbstractTree\Node\Version;
use function sprintf;

class SemVerLike extends NodeAbstract implements Version
{
    /** @var int  */
    public $major;
    /** @var int  */
    public $minor;
    /** @var int  */
    public $patch;

    /** @var string|null  */
    public $prefix;
    /** @var string|null  */
    public $suffix;

    /**
     * @param int $major
     * @param int $minor
     * @param int $patch
     * @param string|null $suffix
     * @param string|null $prefix
     */
    public function __construct(
        int $major,
        int $minor,
        int $patch,
        ?string $suffix = null,
        ?string $prefix = null
    ) {
        $this->major = $major;
        $this->minor = $minor;
        $this->patch = $patch;

        $this->prefix = $prefix;
        $this->suffix = $suffix;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return sprintf(
            '%s%d.%d.%d%s',
            $this->prefix,
            $this->major,
            $this->minor,
            $this->patch,
            $this->suffix
        );
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'V_SemVerLike';
    }

    /**
     * @inheritDoc
     */
    public function getSubNodeNames(): array
    {
        return [

        ];
    }
}
