<?php

declare (strict_types=1);
namespace RectorPrefix20220209;

use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
return static function (\Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator $containerConfigurator) : void {
    $containerConfigurator->import(__DIR__ . '/../config.php');
    $services = $containerConfigurator->services();
    $composerExtensions = [new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'b13/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-swiperjs-simple', 'beewilly/hive_swiperjs_simple'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plain-faq', 'derhansen/plain-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fh-debug', 'jambagecom/fh-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uninstall-phpmyadmin', 'svenjuergens/uninstall_phpmyadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uninstall-phpmyadmin', 'svenjuergens/uninstall_phpmyadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routes', 'lms/routes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uninstall-phpmyadmin', 'svenjuergens/uninstall_phpmyadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routes', 'lms/routes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uninstall-phpmyadmin', 'svenjuergens/uninstall_phpmyadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-cloudfront', 'toumoro/tm-cloudfront'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/copyright', 'verdigado/copyright'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyaccordion', 'quizpalme/tinyaccordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/showcase', 'simonkoehler/showcase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uninstall-phpmyadmin', 'svenjuergens/uninstall_phpmyadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-cloudfront', 'toumoro/tm-cloudfront'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/copyright', 'verdigado/copyright'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container', 'b13/container'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-sync', 'b13/content-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-defender', 'ichhabrecht/content-defender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koe-clearindex', 'koehnlein/koe-clearindex'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid_debug', 'namelesscoder/typo3-cms-fluid-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-form-enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_form_enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyaccordion', 'quizpalme/tinyaccordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wizard_crpagetree', 'reelworx/wizard_crpagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/showcase', 'simonkoehler/showcase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extensionusagefinder', 'sle/extensionusagefinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textimage-size', 'specialistaweb/textimage-size'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-abbr', 'studiomitte/rte-ckeditor-abbr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uninstall-phpmyadmin', 'svenjuergens/uninstall_phpmyadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-cloudfront', 'toumoro/tm-cloudfront'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-masterslave', 'toumoro/tm-masterslave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/copyright', 'verdigado/copyright'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/loginlimit', 'webentwicklerat/loginlimit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler_http', 'webentwicklerat/scheduler-http'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-textmedia-bootstrap', 'websight/ws-textmedia-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container', 'b13/container'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-sync', 'b13/content-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-defender', 'ichhabrecht/content-defender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koe-clearindex', 'koehnlein/koe-clearindex'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid_debug', 'namelesscoder/typo3-cms-fluid-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caddy', 'netzmacher/caddy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchquickshop', 'netzmacher/launchquickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-form-enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_form_enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyaccordion', 'quizpalme/tinyaccordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wizard_crpagetree', 'reelworx/wizard_crpagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/showcase', 'simonkoehler/showcase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extensionusagefinder', 'sle/extensionusagefinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textimage-size', 'specialistaweb/textimage-size'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-abbr', 'studiomitte/rte-ckeditor-abbr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-cloudfront', 'toumoro/tm-cloudfront'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-masterslave', 'toumoro/tm-masterslave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accordion', 'typoniels/accordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/copyright', 'verdigado/copyright'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/loginlimit', 'webentwicklerat/loginlimit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler_http', 'webentwicklerat/scheduler-http'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-textmedia-bootstrap', 'websight/ws-textmedia-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container', 'b13/container'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-sync', 'b13/content-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-fe-admin', 'boergenerwebdesign/bw-fe-admin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-defender', 'ichhabrecht/content-defender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koe-clearindex', 'koehnlein/koe-clearindex'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid_debug', 'namelesscoder/typo3-cms-fluid-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caddy', 'netzmacher/caddy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchquickshop', 'netzmacher/launchquickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-form-enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_form_enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyaccordion', 'quizpalme/tinyaccordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wizard_crpagetree', 'reelworx/wizard_crpagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/showcase', 'simonkoehler/showcase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extensionusagefinder', 'sle/extensionusagefinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textimage-size', 'specialistaweb/textimage-size'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-abbr', 'studiomitte/rte-ckeditor-abbr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-cloudfront', 'toumoro/tm-cloudfront'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-masterslave', 'toumoro/tm-masterslave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hreflang-pages', 'traw/hreflang-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accordion', 'typoniels/accordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/copyright', 'verdigado/copyright'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/loginlimit', 'webentwicklerat/loginlimit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler_http', 'webentwicklerat/scheduler-http'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-textmedia-bootstrap', 'websight/ws-textmedia-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wiro-status', 'wiro/wiro-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container', 'b13/container'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-sync', 'b13/content-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-fe-admin', 'boergenerwebdesign/bw-fe-admin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-defender', 'ichhabrecht/content-defender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koe-clearindex', 'koehnlein/koe-clearindex'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routes', 'lms/routes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid_debug', 'namelesscoder/typo3-cms-fluid-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caddy', 'netzmacher/caddy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchquickshop', 'netzmacher/launchquickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-timeline', 'nitsan/ns-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-form-enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_form_enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyaccordion', 'quizpalme/tinyaccordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wizard_crpagetree', 'reelworx/wizard_crpagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/showcase', 'simonkoehler/showcase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extensionusagefinder', 'sle/extensionusagefinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textimage-size', 'specialistaweb/textimage-size'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-abbr', 'studiomitte/rte-ckeditor-abbr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-cloudfront', 'toumoro/tm-cloudfront'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-masterslave', 'toumoro/tm-masterslave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hreflang-pages', 'traw/hreflang-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accordion', 'typoniels/accordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/copyright', 'verdigado/copyright'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/loginlimit', 'webentwicklerat/loginlimit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler_http', 'webentwicklerat/scheduler-http'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-textmedia-bootstrap', 'websight/ws-textmedia-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wiro-status', 'wiro/wiro-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container', 'b13/container'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-sync', 'b13/content-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-fe-admin', 'boergenerwebdesign/bw-fe-admin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-locallang-builder', 'datamints/locallang_builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-defender', 'ichhabrecht/content-defender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koe-clearindex', 'koehnlein/koe-clearindex'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routes', 'lms/routes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid_debug', 'namelesscoder/typo3-cms-fluid-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caddy', 'netzmacher/caddy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchquickshop', 'netzmacher/launchquickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-timeline', 'nitsan/ns-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-form-enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_form_enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyaccordion', 'quizpalme/tinyaccordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wizard_crpagetree', 'reelworx/wizard_crpagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/showcase', 'simonkoehler/showcase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extensionusagefinder', 'sle/extensionusagefinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textimage-size', 'specialistaweb/textimage-size'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-abbr', 'studiomitte/rte-ckeditor-abbr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file_canonical', 't3/file-canonical'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_cookies', 't3v/t3v_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_core', 't3v/t3v_core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_datamapper', 't3v/t3v_datamapper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_delivery', 't3v/t3v_delivery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_maps', 't3v/t3v_maps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_media', 't3v/t3v_media'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_navigations', 't3v/t3v_navigations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_page', 't3v/t3v_page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_products', 't3v/t3v_products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_stage', 't3v/t3v_stage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_testing', 't3v/t3v_testing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/teamruhr-fal-driver', 'teamruhr/teamruhr-fal-driver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/photoswipe', 'tei/photoswipe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoila_notes', 'templavoilaplus/ppi_templavoila_notes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_csseo', 'templavoilaplus/ppi_templavoilaplus_csseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'templavoilaplus/ppi_templavoilaplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_tvplus_linkvalidator', 'templavoilaplus/ppi_tvplus_linkvalidator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/templavoilaplus', 'templavoilaplus/templavoilaplus'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easy-navigation', 'the-coding-owl/easy-navigation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oclock', 'the-coding-owl/oclock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sql-debug', 'the-coding-owl/sql-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lottie', 'theline/typo3-lottie'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/th-rating', 'thucke/th-rating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timezones', 'thucke/timezones'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt-address', 'tieupmedia/hwt_address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hwt_memorylist', 'tieupmedia/hwt_memorylist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abo', 'tildbj/abo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seeder', 'tildbj/seeder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-bootstrap-grids', 'tmg/fluid-bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_base', 'tollwerk/tw-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw_componentlibrary', 'tollwerk/tw-componentlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tw-events', 'tollwerk/tw-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-cloudfront', 'toumoro/tm-cloudfront'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tm-masterslave', 'toumoro/tm-masterslave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hreflang-pages', 'traw/hreflang-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagecycle', 'typo3-extension/imagecycle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-image-recognition', 'typo3-on-aws/aws-image-recognition'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/themes', 'typo3-themes/themes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/leaflet-osm', 'typo3graf/leaflet-osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accordion', 'typoniels/accordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openimmo', 'ujamii/openimmo-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'ujamii/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translate-locallang', 'undefined/translate-locallang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uw-a11y-check', 'uniwue/uw_a11y_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/site-language-redirection', 'urbantrout/site-language-redirection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'utrotzek/bp-pagetree-fork'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vnc-powermail-encrypt', 'vancado/vnc-powermail-encrypt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/copyright', 'verdigado/copyright'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmailformtoformlegacy', 'verdigado/upmailformtoformlegacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/upmediatotextmedia', 'verdigado/upmediatotextmedia'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'vertexvaar/falsftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-tools', 'viktor-firus/image-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'wdb/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3quotes', 'wdb/t3quotes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'wdb/typo3-forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'web-tp3/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'web-tp3/tp3-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_businessview', 'web-tp3/tp3businessview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_jobs', 'web-tp3/tp3jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3ratings', 'web-tp3/tp3ratings'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tp3_social', 'web-tp3/tp3social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wec-map', 'web-tp3/wec_map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'webdevops/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/emogrifier', 'webentwicklerat/emogrifier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/loginlimit', 'webentwicklerat/loginlimit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler_http', 'webentwicklerat/scheduler-http'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-settings-task', 'webit-de/debug-settings-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler_clearlog_task', 'webit-de/formhandler-clearlog-task'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html2textlibrary', 'webit-de/html2textlibrary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imagewidthspecificationwizard', 'webit-de/imagewidthspecificationwizard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-suomiurl', 'webit-de/realurl-suomiurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-typoscript-rendering-fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl_typoscript_rendering_fix', 'webit-de/realurl-typoscript-rendering-fix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shortcut_statuscodes', 'webit-de/shortcut_statuscodes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3_console_cleartempfiles', 'webit-de/typo3_console_cleartempfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/we-cookie-consent', 'websedit/we-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-textmedia-bootstrap', 'websight/ws-textmedia-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wh-save-buttons', 'widerheim/wh-save-buttons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomdata', 'windinternet/randomdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wiro-status', 'wiro/wiro-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/buildinfo', 'worlddirect/buildinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/booking', 'wsr/booking'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myflat', 'wsr/myflat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myleaflet', 'wsr/myleaflet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mymap', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-key', 'wsr/mymap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/myttaddressmap', 'wsr/myttaddressmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm-viewhelper', 'xima-media/xm-viewhelper'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xm_tools', 'xima-media/xm_tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/soundcloud', 'yahatix/soundcloud'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yoast-seo', 'yoast-seo-for-typo3/yoast_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_cookies', 'aaw-team/fe_cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagenotfoundhandling', 'aaw-team/pagenotfoundhandling'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wufoo', 'aaw-team/wufoo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/abexto-schemaorg-breadcrumb', 'abexto/abexto-schemaorg-breadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-analytics-and-adwords', 'adswerve/google-analytics-and-adwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/registeraddress', 'afm/registeraddress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aimeos', 'aimeos/aimeos-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-connector', 'alexander-nitsche/typo3-nginx-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ama-t3-upgrade-assistant', 'amartinno1/ama-t3-upgrade-assistant'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aus_driver_amazon_s3', 'andersundsehr/aus-driver-amazon-s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-address', 'andreaskastl/calendarize-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openweatherapi', 'andreaskastl/openweatherapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/aoe-dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aoe-dbsequenzer', 'aoe/dbsequenzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crawler', 'aoepeople/crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solr', 'apache-solr-for-typo3/solr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrfluidexample', 'apache-solr-for-typo3/solrfluidexample'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrgrouping', 'apache-solr-for-typo3/solrgrouping'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/solrmlt', 'apache-solr-for-typo3/solrmlt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tika', 'apache-solr-for-typo3/tika'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/evangtermine', 'arbkomekvw/evangtermine'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaconsent', 'arbkomekvw/mediaconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 'arminvieweg/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/improve-processed-filename', 'arndtteunissen/improve-processed-filename'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clear-cache-command', 'arndtteunissen/realurl-clear-cache-command'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/atslider', 'ashokatree/atslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-tab', 'ayacoo/redirect-tab'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'azich/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'b13/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container', 'b13/container'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-sync', 'b13/content-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geocoding', 'b13/geocoding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/justincase', 'b13/justincase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/masi', 'b13/masi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memolist', 'b13/memolist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo-basics', 'b13/seo_basics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cooluri', 'bednee/cooluri'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backup-restore', 'beechit/backup-restore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bynder', 'beechit/bynder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-securedownload', 'beechit/fal-securedownload'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-lib-swiperjs', 'beewilly/hive_lib_swiperjs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-poi', 'beewilly/hive_poi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hive-scheduler', 'beewilly/hive_scheduler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail-voucher', 'belsignum/powermail-voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bwrk-onepage', 'bergwerk/bwrk-onepage'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bss-events', 'bermuda/typo3-bss-events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bgm-hreflang', 'bgm/bgm-hreflang'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pdfviewhelpers', 'bithost-gmbh/pdfviewhelpers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'bitmotion/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'bitmotion/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom-error-page', 'bitmotion/custom-error-page'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gone', 'bitmotion/gone'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'bitmotion/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'bitmotion/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'bitmotion/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'bitmotion/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'bitmotion/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'bitmotion/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'bitmotion/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'bitmotion/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'bitmotion/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'bitmotion/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'bitmotion/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'bitmotion/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'bitmotion/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autogrids', 'bk2k/autogrids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/syntax', 'bk2k/syntax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slim_typo3', 'bnf/slim-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-fe-admin', 'boergenerwebdesign/bw-fe-admin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw-gallery', 'boergenerwebdesign/bw-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_connector', 'brainappeal/campus_events_connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2news', 'brainappeal/campus_events_convert2news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnews', 'brainappeal/campus_events_convert2ttnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_convert2ttnewscal', 'brainappeal/campus_events_convert2ttnewscal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/campus_events_frontend', 'brainappeal/campus_events_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-newsletter', 'brainworxx/form-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/includekrexx', 'brainworxx/includekrexx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazyfxx', 'brainworxx/lazyfxx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cbgooglemaps', 'brinkert/cbgooglemaps'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/byt_coordconverter', 'brotkrueml/coordconverter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extpagetitle', 'brotkrueml/extpagetitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-records', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/schema-ce', 'brotkrueml/schema-records'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sdbreadcrumb', 'brotkrueml/sdbreadcrumb'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-connector', 'brotkrueml/typo3-jobrouter-connector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-jobrouter-data', 'brotkrueml/typo3-jobrouter-data'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bw_jobs', 'browserwerk/bw_jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auxlibs', 'buepro/typo3-auxlibs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'buepro/typo3-bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/container-elements', 'buepro/typo3-container-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux-elements', 'buepro/typo3-flux-elements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue', 'buepro/typo3-pizpalue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pizpalue-distribution', 'buepro/typo3-pizpalue-distribution'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pp-gridelements', 'buepro/typo3-pp-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realer', 'buepro/typo3-realer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/timelog', 'buepro/typo3-timelog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bp_pagetree', 'bueroparallel/bp-pagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchcache', 'bugfix/patchcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patchlayout', 'bugfix/patchlayout'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulatebe', 'cabag/simulatebe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microformat', 'cabi/microformat'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker', 'caretaker/caretaker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caretaker_instance', 'caretaker/caretaker_instance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cwhtmlcompressor', 'carstenwindler/cwhtmlcompressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cloudflare', 'causal/cloudflare'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/css2inline', 'causal/css2inline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail-userfunc', 'causal/direct_mail_userfunc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extractor', 'causal/extractor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-list', 'causal/file_list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-ldap-sso-auth', 'causal/ig_ldap_sso_auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-autoresize', 'causal/image_autoresize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc', 'causal/oidc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'causal/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routing', 'causal/routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-api', 'causal/simple_api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'causal/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tscobj', 'causal/tscobj'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/list-cal', 'ccpp/list-cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cdsrc_bepwreset', 'cdsrc/cdsrc-bepwreset'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transladder', 'cedricziel/transladder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'checkitsedo/checkitcalendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'checkitsedo/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_int', 'christianessl/adminpanel_int'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/adminpanel_routing', 'christianessl/adminpanel_routing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixrootpageaccess', 'christianessl/fixrootpageaccess'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/impersonate', 'christianessl/impersonate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/js_logger', 'christianessl/js_logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/placeholder_images', 'christianessl/placeholder_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tabmoduleclick', 'christianessl/tabmoduleclick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_browser', 'christianessl/yaml_browser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youku', 'christianessl/youku'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/httpbasicauth', 'christophlehmann/httpbasicauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageoptimizer', 'christophlehmann/imageoptimizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailhandler', 'chriwo/mailhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staffholiday', 'chriwo/staffholiday'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-file-meta-fill', 'clickstorm/cs-file-meta-fill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_powermail_gdpr', 'clickstorm/cs_powermail_gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs_seo', 'clickstorm/cs_seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/go-maps-ext', 'clickstorm/go_maps_ext'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bolt', 'cmsexperts/bolt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/api', 'co-stack/api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal-sftp', 'co-stack/fal_sftp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/external_import', 'cobweb/external_import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/externalimport_tut', 'cobweb/externalimport_tut'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flush_language_cache', 'cobweb/flush_language_cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector', 'cobweb/svconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_csv', 'cobweb/svconnector_csv'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_feed', 'cobweb/svconnector_feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_json', 'cobweb/svconnector_json'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/svconnector_sql', 'cobweb/svconnector_sql'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-beskin', 'codefareith/cf-beskin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf-google-authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cf_google_authenticator', 'codefareith/cf-google-authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailmanager', 'codeminds/mailmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-google-auth', 'codemonkey1988/be-google-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-static-auth', 'codemonkey1988/be-static-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/image-compression', 'codemonkey1988/image-compression'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/responsive-images', 'codemonkey1988/responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/script-style-push', 'codemonkey1988/script-style-push'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/anfahrt', 'colorcube/anfahrt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auto404', 'colorcube/auto404'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bookmark-pages', 'colorcube/bookmark-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-feinfo', 'colorcube/cc-feinfo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cc-magicpw', 'colorcube/cc-magicpw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-overview', 'colorcube/content-overview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookie-redirect', 'colorcube/cookie-redirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dummy-content', 'colorcube/dummy-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file-ref-list', 'colorcube/file-ref-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-proc-tester', 'colorcube/rte-proc-tester'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/shredder', 'colorcube/shredder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simulate-static-urls', 'colorcube/simulate-static-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/commerce', 'commerceteam/commerce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'communiacs/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry_client', 'comsolit/sentry_client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/twig-for-typo3', 'comwrap/typo3-twig_for_typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'cpsit/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/course-qcat-export', 'cpsit/course-qcat-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/geo-location-service', 'cpsit/geo-location-service'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_course', 'cpsit/t3events_course'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events_reservation', 'cpsit/t3events_reservation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3import-export', 'cpsit/t3import_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vcc', 'cpsit/vcc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/notiz', 'cuyz/notiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_twig', 'cvc/typo3-twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cvc_webauthn', 'cvc/typo3-webauthn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-feuser', 'datamints/feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datamints-locallang-builder', 'datamints/locallang_builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/datec-losungen', 'datec/datec-losungen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sqllog', 'datenbetrieb/sqllog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-reviews', 'ddoronenko/google-reviews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5mediakit', 'de-swebhosting-typo3-extension/html5mediakit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mediaoembed', 'de-swebhosting-typo3-extension/mediaoembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyurls', 'de-swebhosting-typo3-extension/tinyurls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/force-pwd-change-fe', 'derhansen/fe_change_pwd'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pwd-security-check', 'derhansen/pwd_security_check'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-banners', 'derhansen/sf_banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-event-mgt', 'derhansen/sf_event_mgt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-yubikey', 'derhansen/sf_yubikey'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tobserver', 'derhansen/tobserver'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'devlog/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dm-developerlog', 'diemedialen/dm-developerlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidcontent-flux-migration', 'different-technology/fluidcontent-flux-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ses_mailer', 'different-technology/ses-mailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league', 'digedag/cfc-league'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cfc-league-fe', 'digedag/cfc-league-fe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dfbsync', 'digedag/dfbsync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/more4t3sports', 'digedag/more4t3sports'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rn-base', 'digedag/rn-base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportsbet', 'digedag/t3sportsbet'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sportstats', 'digedag/t3sportstats'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beaconizer', 'digicademy/beaconizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_geo', 'digicademy/chf_geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/chf_time', 'digicademy/chf_time'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xpath', 'digicademy/cobj_xpath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cobj_xslt', 'digicademy/cobj_xslt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-element-registry', 'digitalwerk/content-element-registry'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/direct-mail', 'directmailteam/direct-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_cookieconsent', 'dirkpersky/typo3-dp_cookieconsent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dp_http2', 'dirkpersky/typo3-dp_http2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte_ckeditor_fontawesome', 'dirkpersky/typo3-rte-ckeditor-fontawesome'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieman', 'dmind/cookieman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dd-googlesitemap', 'dmitryd/typo3-dd-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'dmitryd/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-trace', 'dmitryd/typo3-realurl-trace'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkforms', 'dmk/mkforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklib', 'dmk/mklib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mklog', 'dmk/mklog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkmailer', 'dmk/mkmailer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkpostman', 'dmk/mkpostman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksamlauth', 'dmk/mksamlauth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksanitizedparameters', 'dmk/mksanitizedparameters'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mksearch', 'dmk/mksearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mktools', 'dmk/mktools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mkvarnish', 'dmk/mkvarnish'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3rest', 'dmk/t3rest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3twig', 'dmk/t3twig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3users', 'dmk/t3users'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'dominiksenti/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gatedcontent', 'dpool/gatedcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxmap', 'dwenzel/ajaxmap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3events', 'dwenzel/t3events'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/easydb', 'easydb/typo3-integration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eh-backend', 'ehaerer/eh-backend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe-upload-example', 'ehaerer/fe-upload-example'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscriptconditions', 'elementareteilchen/typoscriptconditions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf-register', 'evoweb/sf-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/questionaire', 'exotec/questionaire'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth-basic', 'extrameile/auth-basic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em-sys-note', 'extrameile/em-sys-note'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_form_repeatablesave', 'extrameile/em_form_repeatablesave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_pagespeedinsights', 'extrameile/em_tvplus_pagespeedinsights'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/em_tvplus_theme_demo', 'extrameile/em_tvplus_theme_demo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ppi_templavoilaplus_yoast', 'extrameile/em_tvplus_yoast'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/matomoapi', 'famouswolf/matomoapi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpn-glossary', 'featdd/dpn-glossary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deletefiles', 'felixnagel/deletefiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fe_performance', 'felixnagel/fe-performance'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailfiles', 'felixnagel/mailfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pluploadfe', 'felixnagel/pluploadfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacyguard', 'felixnagel/privacyguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3extblog', 'felixnagel/t3extblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 'fgtclb/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3', 'fidelo/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/storage-framework-manager', 'filoucrackeur/storage-framework-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backendtools', 'fixpunkt/backendtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-fractionslider', 'fixpunkt/fp-fractionslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-masterquiz', 'fixpunkt/fp-masterquiz'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fp-newsletter', 'fixpunkt/fp-newsletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'fluidtypo3/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs', 'fluidtypo3/vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/format_t3tools', 'formatsoft/format_t3tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/func', 'friendsoftypo3/cms-func'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility6', 'friendsoftypo3/compatibility6'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/compatibility7', 'friendsoftypo3/compatibility7'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/crowdin', 'friendsoftypo3/crowdin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'friendsoftypo3/extension-builder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontend-editing', 'friendsoftypo3/frontend-editing'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jumpurl', 'friendsoftypo3/jumpurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/openid', 'friendsoftypo3/openid'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rdct', 'friendsoftypo3/rdct'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-address', 'friendsoftypo3/tt-address'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/frontify_typo3', 'frontify/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/debug-mysql-db', 'geithware/debug-mysql-db'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoswitchtolistview', 'georgringer/autoswitchtolistview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/backend-debug', 'georgringer/backend-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/deprecationloganalyzer', 'georgringer/deprecationloganalyzer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/doc', 'georgringer/doc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eventnews', 'georgringer/eventnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extbase-records-with-no-l10n-parent', 'georgringer/extbase-records-with-no-l10n-parent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faker', 'georgringer/faker'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gdpr', 'georgringer/gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/insert-records-overlaymode', 'georgringer/insert-records-overlaymode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'georgringer/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-fal-migration', 'georgringer/news-fal-migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-feuser', 'georgringer/news-feuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-filter', 'georgringer/news-filter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-gallery', 'georgringer/news-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-importicsxml', 'georgringer/news-importicsxml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news-subheadline', 'georgringer/news-subheadline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/noopener', 'georgringer/noopener'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/numbered-pagination', 'georgringer/numbered-pagination'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect-generator', 'georgringer/redirect-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/uri2link', 'georgringer/uri2link'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mentor-finder', 'gi/mentor-finder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gscacheconfig', 'gilbertsoft/gscacheconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsfavicon', 'gilbertsoft/gsfavicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gsprotectedconfig', 'gilbertsoft/gsprotectedconfig'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gswarranty', 'gilbertsoft/gswarranty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gslib', 'gilbertsoft/typo3-gslib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gkh-rss-import', 'gkh/gkh-rss-import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gridelements', 'gridelementsteam/gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jh_captcha', 'haffner/jh_captcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-add-statuscode', 'hauerheinrich/hh-add-statuscode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh_ckeditor_custom', 'hauerheinrich/hh-ckeditor-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-slider', 'hauerheinrich/hh-slider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hh-video-extender', 'hauerheinrich/hh-video-extender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-rendering', 'helhum/typoscript-rendering'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug_autoupdate', 'hendrikreimers/slug_autoupdate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock', 'higidi/typo3-lock'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devlog', 'hmmh/devlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formsave', 'hn/formsave'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hidpi', 'hn/hidpi'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intl', 'hn/intl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-permissions', 'hov/mask-permissions'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2pagetypesuffix', 'hziegenhain/redirect2pagetypesuffix'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/begroups-roles', 'ichhabrecht/begroups-roles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-defender', 'ichhabrecht/content-defender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/core-upgrader', 'ichhabrecht/core-upgrader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/devtools', 'ichhabrecht/devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/filefill', 'ichhabrecht/filefill'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-used-content', 'ichhabrecht/hide-used-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hosts-pattern', 'ichhabrecht/hosts-pattern'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/intcache', 'ichhabrecht/intcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask-export', 'ichhabrecht/mask-export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/multicolumn', 'ichhabrecht/multicolumn'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/social-gdpr', 'ichhabrecht/social-gdpr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3tags', 'ichhabrecht/t3tags'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data_handler_queue', 'ideative/data_handler_queue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/news', 'ideativedigital/news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ifab-realestate', 'ifabrik/ifab-realestate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iizuna', 'iizunats/iizuna'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/email2powermail', 'in2code/email2powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager', 'in2code/femanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fetchurl', 'in2code/fetchurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/groupdelegation', 'in2code/groupdelegation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2frontendauthentication', 'in2code/in2frontendauthentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/in2help', 'in2code/in2help'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/invisiblerecaptcha', 'in2code/invisiblerecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguageredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipandlanguageredirect', 'in2code/ipandlanguagesuggest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lux', 'in2code/lux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/luxletter', 'in2code/luxletter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration', 'in2code/migration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/osm', 'in2code/osm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermail', 'in2code/powermail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/powermailrecaptcha', 'in2code/powermailrecaptcha'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/publications', 'in2code/publications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript2ce', 'in2code/typoscript2ce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/appointments', 'innologi/typo3-appointments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/decosdata', 'innologi/typo3-decosdata'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fileman', 'innologi/typo3-fileman'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/streamovations-vp', 'innologi/typo3-streamovations-vp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/unroll', 'instituteweb/unroll'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authcode', 'intera-typo3-extension/authcode'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cacheopt', 'intera-typo3-extension/cacheopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ig-slug', 'internetgalerie/ig-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ipm-cline', 'ipandmore/ipm-cline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-news', 'itplusx/flexible-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flexible-pages', 'itplusx/flexible-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless_gridelements', 'itplusx/headless-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headless', 'itplusx/typo3-headless'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typoscript-code', 'itribe/typoscript-code'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jobapplications', 'itx/jobapplications'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-em', 'jambagecom/addons-em'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/addons-tt-products', 'jambagecom/addons-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/agency', 'jambagecom/agency'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-cache', 'jambagecom/base-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-excel', 'jambagecom/base-excel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-font', 'jambagecom/base-font'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-pdf', 'jambagecom/base-pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/base-svg', 'jambagecom/base-svg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/div2007', 'jambagecom/div2007'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/excelbill-tt-products', 'jambagecom/excelbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import', 'jambagecom/import'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-address-nicosdir', 'jambagecom/import-tt-address-nicosdir'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/import-tt-board-comments', 'jambagecom/import-tt-board-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jfmulticontent', 'jambagecom/jfmulticontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-searchbox', 'jambagecom/macina-searchbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mastertemplate', 'jambagecom/mastertemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mbi-products-categories', 'jambagecom/mbi-products-categories'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/migration-core', 'jambagecom/migration-core'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/move', 'jambagecom/move'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/patch10011', 'jambagecom/patch10011'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quotation-tt-products', 'jambagecom/quotation-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-da', 'jambagecom/static-info-tables-da'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-de', 'jambagecom/static-info-tables-de'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-es', 'jambagecom/static-info-tables-es'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-it', 'jambagecom/static-info-tables-it'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-taxes', 'jambagecom/static-info-tables-taxes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/table', 'jambagecom/table'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/taxajax', 'jambagecom/taxajax'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tcpdfbill-tt-products', 'jambagecom/tcpdfbill-tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/transactor', 'jambagecom/transactor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tslib-fetce', 'jambagecom/tslib-fetce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsparser', 'jambagecom/tsparser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-board', 'jambagecom/tt-board'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-guest', 'jambagecom/tt-guest'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products', 'jambagecom/tt-products'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt-products-foundby', 'jambagecom/tt-products-foundby'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/voucher', 'jambagecom/voucher'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/watchwords', 'jambagecom/watchwords'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cal', 'janhelke/cal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content_owners', 'jansass/content-owners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wechange', 'jazzica/wechange'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'jbartels/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/memcacheddiag2', 'jbartels/memcacheddiag2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redis_diag', 'jbartels/redis_diag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/global-popup', 'joekolade/global-popup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/visibility', 'joekolade/visibility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/eepcollect', 'jokumer/eepcollect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/privacy', 'jokumer/privacy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xfilelist', 'jokumer/xfilelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jn_phpcontentelement', 'joppnet/jn_phpcontentelement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/beuser-fastswitch', 'josefglatz/beuser-fastswitch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cropvariantsbuilder', 'josefglatz/cropvariantsbuilder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/development_only', 'josefglatz/development-only'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hide-sys-template', 'josefglatz/hide-sys-template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/iconcheck', 'josefglatz/iconcheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seo_aspect_ratios', 'josefglatz/seo-aspect-ratios'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/toolbar-clear-processedfiles', 'josefglatz/toolbar-clear-processedfiles'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tvplus-contentslide', 'jpmschuler/tvplus-contentslide'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jpfaq', 'jvdp/jpfaq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jv-add2group', 'jvelletti/jv-add2group'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacer', 'jweiland/replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reserve', 'jweiland/reserve'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tc-beuser', 'jweiland/tc-beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kz-ce-templating', 'kabaz/kz-ce-templating'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'kaesetoast/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3cv_export', 'kamiyang/ext-t3cv_export'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fire-department', 'kanow/fire-department'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/operations', 'kanow/operations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flux', 'kanti/flux'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl', 'kanti/typo3-realurl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-zurb-framework', 'karavas/foundation-zurb-framework'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/highlight-js', 'karavas/highlight-js'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss', 'kaystrobach/dyncss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_less', 'kaystrobach/dyncss-less'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dyncss_scss', 'kaystrobach/dyncss_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restdoc', 'kiefer79/restdoc'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sphinx', 'kiefer79/sphinx'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dlf', 'kitodo/presentation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dpf', 'kitodo/publication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-assets', 'kitt3n/kitt3n-assets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-brand', 'kitt3n/kitt3n-brand'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-custom', 'kitt3n/kitt3n-custom'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-detection', 'kitt3n/kitt3n-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-image', 'kitt3n/kitt3n-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-law', 'kitt3n/kitt3n-law'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-layouts', 'kitt3n/kitt3n-layouts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-libs', 'kitt3n/kitt3n-libs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-loop', 'kitt3n/kitt3n-loop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-services', 'kitt3n/kitt3n-services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-userfuncs', 'kitt3n/kitt3n-userfuncs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/kitt3n-xclasses', 'kitt3n/kitt3n-xclasses'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/indexed_search_autocomplete', 'kitzberger/indexed-search-autocomplete'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slug', 'koehlersimon/slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koe-clearindex', 'koehnlein/koe-clearindex'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/scheduler-disable-runtask', 'koehnlein/scheduler-disable-runtask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-comments', 'koninklijke-collective/koning-comments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/koning-library', 'koninklijke-collective/koning-library'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-redirects', 'koninklijke-collective/my-redirects'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-user-management', 'koninklijke-collective/my-user-management'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'koweb/static-info-tables-iso629'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap-grids', 'laxap/bootstrap-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/auth0', 'leuchtfeuer/auth0'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/aws-tools', 'leuchtfeuer/aws-tools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bm-image-gallery', 'leuchtfeuer/bm-image-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/languagemod', 'leuchtfeuer/languagemod'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/locate', 'leuchtfeuer/locate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/marketing-automation', 'leuchtfeuer/marketing-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/secure-downloads', 'leuchtfeuer/secure-downloads'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ar', 'leuchtfeuer/static-info-tables-ar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-bg', 'leuchtfeuer/static-info-tables-bg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-cs', 'leuchtfeuer/static-info-tables-cs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fa', 'leuchtfeuer/static-info-tables-fa'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hr', 'leuchtfeuer/static-info-tables-hr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-hu', 'leuchtfeuer/static-info-tables-hu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-id', 'leuchtfeuer/static-info-tables-id'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ko', 'leuchtfeuer/static-info-tables-ko'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt-br', 'leuchtfeuer/static-info-tables-pt-br'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sr', 'leuchtfeuer/static-info-tables-sr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-th', 'leuchtfeuer/static-info-tables-th'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-uk', 'leuchtfeuer/static-info-tables-uk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/audience-studio', 'leuchtfeuer/typo3-audience-studio'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-iso639', 'lgescobar/static-info-tables-iso639'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vectormap', 'lightwerk/vectormap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/routes', 'lms/routes'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10nmgr', 'localizationteam/l10nmgr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoloader', 'lochmueller/autoloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize', 'lochmueller/calendarize'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-news', 'lochmueller/calendarize-news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/calendarize-pages', 'lochmueller/calendarize-pages'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/faq', 'lochmueller/faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fl-realurl-image', 'lochmueller/fl_realurl_image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google_services', 'lochmueller/google_services'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html5videoplayer', 'lochmueller/html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/perfectlightbox', 'lochmueller/perfectlightbox'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sourceopt', 'lochmueller/sourceopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-zh', 'lochmueller/static-info-tables-zh'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/staticfilecache', 'lochmueller/staticfilecache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/validator', 'lochmueller/validator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/enetcache', 'lolli/enetcache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wm-pagepath', 'lsascha/wm-pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_api', 'luitd/lu-api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_auth', 'luitd/lu-auth'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_contacts', 'luitd/lu-contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_content', 'luitd/lu-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu-monitoring', 'luitd/lu-monitoring'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nabamusic', 'luitd/lu-nabamusic'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_names', 'luitd/lu-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_nas', 'luitd/lu-nas'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_notices', 'luitd/lu-notices'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_search', 'luitd/lu-search'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lu_study_catalogue', 'luitd/lu-study-catalogue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pm_attachments', 'luitd/pm-attachments'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pl', 'lukaszuznanski/static-info-tables-pl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/l10n-translator', 'lw/l10n-translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi_map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/poi-map', 'm2s/typo3-poi-map'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-drive-fal', 'mabolek/google-drive-fal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sf_filecollection_gallery', 'machwatt/sf_filecollection_gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ms_instafeed', 'marekskopal/typo3-instafeed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-compress', 'markussom/html-compress'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sitemap-generator', 'markussom/sitemap-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mask', 'mask/mask'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mautic', 'mautic/mautic-typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/jshrink', 'maximilian-walter/typo3-jshrink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/accountmanagement', 'maxserv/accountmanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fal_s3', 'maxserv/fal_s3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/parsedown', 'maxserv/parsedown'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replacecontent', 'maxserv/replacecontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'maxserv/yaml_configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo', 'mblaschke/metaseo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/coinimptypo3', 'mdy/coinimptypo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/costumcontentpreview', 'mdy/costumcontentpreview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fixedsidemenu-ext-key', 'mdy/fixedsidemenu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/headertoallelements', 'mdy/headertoallelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/readmorelink', 'mdy/readmorelink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_calendarize_frontend', 'mediadreams/md_calendarize_frontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-fullcalendar', 'mediadreams/md_fullcalendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_newsfrontend', 'mediadreams/md_newsfrontend'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md_unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/md-unreadnews', 'mediadreams/md_unreadnews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/domaincheck', 'mediaessenz/domaincheck'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/me-google-calendar', 'mediaessenz/me-google-calendar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form_fieldnames', 'mediatis/form_fieldnames'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay', 'mediatis/formrelay'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-mail', 'mediatis/formrelay-mail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formrelay-salesforce', 'mediatis/formrelay-salesforce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/inm_googlesitemap', 'merzilla/inm-googlesitemap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'mhuber84/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/randomizer', 'mhuber84/randomizer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bugsnag', 'michielroos/bugsnag'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/h5p', 'michielroos/h5p'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mindshape-cookie-consent', 'mindshape/mindshape-cookie-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fs-media-gallery', 'minifranske/fs-media-gallery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/gravatar', 'minifranske/gravatar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lazy_load_placeholder', 'minifranske/lazy-load-placeholder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange_saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniorange-saml', 'miniorange/miniorange-saml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-forum', 'mittwald/typo3_forum'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/web2pdf', 'mittwald/web2pdf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookiebot', 'mjpr/cookiebot'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ceselector', 'mmc/ceselector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-directmail-subscription', 'mmc/directmail-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-extbasewsutility', 'mmc/extbasewsutility'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc_guestbook', 'mmc/guestbook'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mmc-slideshow', 'mmc/slideshow'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/plausible-analytics', 'mmk2410/plausible-analytics'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-fr', 'mselbach/static-info-tables-fr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ja', 'mselbach/static-info-tables-ja'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ru', 'mselbach/static-info-tables-ru'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-sk', 'mselbach/static-info-tables-sk'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-ua', 'mselbach/static-info-tables-ua'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/na_fluxdummy', 'naderio/na-fluxdummy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid_debug', 'namelesscoder/typo3-cms-fluid-debug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/canonical-url', 'nemo64/canonical-url'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nr-sync', 'netresearch/nr-sync'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-image', 'netresearch/rte-ckeditor-image'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sentry-client', 'networkteam/sentry-client'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/caddy', 'netzmacher/caddy'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launch', 'netzmacher/launch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchquickshop', 'netzmacher/launchquickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstart', 'netzmacher/launchstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/launchstartgreen', 'netzmacher/launchstartgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/org', 'netzmacher/org'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/quickshop', 'netzmacher/quickshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/slick', 'netzmacher/slick'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/start', 'netzmacher/start'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startcustomer', 'netzmacher/startcustomer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/startgreen', 'netzmacher/startgreen'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3foundation', 'netzmacher/t3foundation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tsconf', 'netzmacher/tsconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/xblog', 'netzmacher/xblog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hyphen-dictionary', 'neues-studio/hyphen-dictionary'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-backup', 'nitsan/ns-backup'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-cookies', 'nitsan/ns-cookies'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-googledocs', 'nitsan/ns-googledocs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-protect-site', 'nitsan/ns-protect-site'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-timeline', 'nitsan/ns-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ns-whatsapp', 'nitsan/ns-whatsapp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/custom_dashboard_widgets', 'o-ba/custom_dashboard_widgets'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dw-content-protector', 'ogrosko/dw-content-protector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-csv_to_openimmo', 'oliverklee/csv_to_openimmo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oelib', 'oliverklee/oelib'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/onetimeaccount', 'oliverklee/onetimeaccount'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phpunit', 'oliverklee/phpunit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realty', 'oliverklee/realty'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/seminars', 'oliverklee/seminars'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tea', 'oliverklee/tea'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-devsite', 'oliverklee/typo3-devsite'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsforms', 'onm/hsforms'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hsmail', 'onm/hsmail'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/int-park', 'onm/int-park'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/om-cookie-consent', 'opfaff/om-cookie-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/csp', 'ottoandras/typo3-csp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-acl', 'p2media/be-acl'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/phrases_translator', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extension-builder', 'pablosdos/phrases_translator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cors', 'pagemachine/cors'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hairu', 'pagemachine/hairu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/flat-urls', 'pagemachine/typo3-flat-urls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formlog', 'pagemachine/typo3-formlog'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-css-inliner', 'pagemachine/typo3-mail-css-inliner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/url-forwarding', 'patrickbroens/url-forwarding'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/google-for-jobs', 'pegasus/google-for-jobs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pfaffenrodt/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/authenticator', 'pgampe/authenticator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'phorax/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ja_replacer', 'phorax/ja-replacer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pits-download-center', 'pits/downloadcenter'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/snowbabel', 'pits/snowbabel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-cookie-bar', 'pixelant/pxa-cookie-bar'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-data-provider', 'pixelant/pxa-data-provider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-dealers', 'pixelant/pxa-dealers'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-fal-file-list', 'pixelant/pxa-fal-file-list'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-form-enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_form_enhancement', 'pixelant/pxa-form-enhancement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa_images_compressor', 'pixelant/pxa-images-compressor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-newsletter-subscription', 'pixelant/pxa-newsletter-subscription'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-product-manager', 'pixelant/pxa-product-manager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-site-choice-recommendation', 'pixelant/pxa-site-choice-recommendation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-siteimprove', 'pixelant/pxa-siteimprove'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pxa-social-feed', 'pixelant/pxa-social-feed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbank', 'pixelant/qbank'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/simple-rss', 'pixelink/simple-rss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/vhs_scss', 'pkerling/vhs_scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pb_social', 'plusb/pb_social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache_automation', 'pluswerk/cache-automation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-logger', 'pluswerk/mail-logger'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_shopware', 'portrino/px_shopware'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/px_validation', 'portrino/px_validation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pn-uniform-product-names', 'proudnerds-typo3/pn-uniform-product-names'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-seo', 'psvneo/t3-extension-seo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pti', 'pti/pti'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extbase', 'punktde/pt_extbase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt-extlist', 'punktde/pt_extlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pt_migrations', 'punktde/pt_migrations'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autoflush', 'qbus/autoflush'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cache-status', 'qbus/cache-status'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/data-consent', 'qbus/data-consent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/nginx-cache', 'qbus/nginx-cache'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents', 'qbus/qbevents'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/qbevents_kesearch', 'qbus/qbevents-kesearch'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/serp', 'qbus/serp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/skip-page-is-being-generated', 'qbus/skip-page-is-being-generated'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/subsite_generator', 'qbus/subsite-generator'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/camaliga', 'quizpalme/camaliga'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyaccordion', 'quizpalme/tinyaccordion'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ghost-content', 'r3h6/ghost-content'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oauth2-server', 'r3h6/oauth2-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/oidc-server', 'r3h6/oidc-server'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3devtools', 'r3h6/t3devtools'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-scheduled-social', 'reelworx/rx-scheduled-social'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rx-shariff', 'reelworx/rx-shariff'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/wizard_crpagetree', 'reelworx/wizard_crpagetree'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/reint-downloadmanager', 'renolit/reint-downloadmanager'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-pt', 'renolit/static-info-tables-pt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-re-add-iso', 'renolit/static-info-tables-re-add-iso'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables-tr', 'renolit/static-info-tables-tr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland', 'resterland/resterland'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/resterland-bootstrap', 'resterland/resterland-bootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlkickstart', 'resterland/rlkickstart'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmembermanagement', 'resterland/rlmembermanagement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlwebshop', 'resterland/rlwebshop'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/webatelier', 'resterland/webatelier'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/bootstrap_package-dvoconnector', 'rgu/bootstrap_package-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dvoconnector', 'rgu/dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-dvoconnector', 'rgu/metaseo-dvoconnector'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/metaseo-vhs', 'rgu/metaseo-vhs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dynamic-faq', 'riconet/dynamic-faq'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-dal', 'riconet/t3-extension-dal'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-fairs', 'riconet/t3-extension-fairs'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-folder-based-download-center', 'riconet/t3-extension-folder-based-download-center'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-softgarden', 'riconet/t3-extension-softgarden'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rico-talentstorm', 'riconet/t3-extension-talentstorm'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rkw_digi_kit', 'rkw/digikit'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rlmp-language-detection', 'rlmp/rlmp-language-detection'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/configuration-object', 'romm/configuration-object'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tt_news', 'rupertgermann/tt_news'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mapgeoadmin', 'saccas/mapgeoadmin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mjml', 'saccas/mjml'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtube_gdprembed', 'saschaschieferdecker/youtube_gdprembed'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mr_template', 'scarbous/mr_template'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/grid-for-gridelements', 'schmidtwebmedia/grid-for-gridelements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinyimg', 'schmitzal/tinyimg'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluid-styled-responsive-images', 'schnitzler/fluid-styled-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-kalender', 'scoutnet/sh-scoutnet-kalender'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sh-scoutnet-webservice', 'scoutnet/sh-scoutnet-webservice'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ajaxselectlist', 'sebkln/ajaxselectlist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/content-slug', 'sebkln/content-slug'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/my-search-crawler', 'serfhos/my-search-crawler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/assetsloader', 'sethorax/typo3-assetloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dcp', 'sethorax/typo3-dcp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/directcontent', 'sethorax/typo3-directcontent'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/fluidloader', 'sethorax/typo3-fluidloader'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lfeditor', 'sgalinski/lfeditor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/spamshield', 'sgalinski/spamshield'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce', 'sgalinski/tinymce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/tinymce4-rte', 'sgalinski/tinymce4-rte'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ce-timeline', 'simonkoehler/ce-timeline'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/showcase', 'simonkoehler/showcase'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textile', 'simonkoehler/textile'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/foundation-grids', 'simonschaufi/foundation-grids'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock-element', 'simonschaufi/lock-element'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macina-banners', 'simonschaufi/macina-banners'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/importr', 'sirdiego/importr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms-responsive-images', 'sitegeist/sms-responsive-images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatelabels', 'sitegeist/translatelabels'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-email-subscribe', 'sjbr/sr-email-subscribe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-feuser-register', 'sjbr/sr-feuser-register'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr-freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-language-menu', 'sjbr/sr-language-menu'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sr-freecap', 'sjbr/sr_freecap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/static-info-tables', 'sjbr/static-info-tables'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extensionusagefinder', 'sle/extensionusagefinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/autourls', 'smichaelsen/autourls'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagepath', 'smichaelsen/pagepath'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sg-replacement', 'smplygd/sg-replacement'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sms77typo3', 'sms77/sms77typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lib-jquery', 'sonority/lib-jquery'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/hugo', 'sourcebroker/hugo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/imageopt', 'sourcebroker/imageopt'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ip2geo', 'sourcebroker/ip2geo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/restrictfe', 'sourcebroker/restrictfe'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/singleview', 'sourcebroker/singleview'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3api', 'sourcebroker/t3api'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apinews', 'sourcebroker/t3apinews'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3apitranslatr', 'sourcebroker/t3apitranslatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/translatr', 'sourcebroker/translatr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard', 'sourcebroker/urlguard'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/textimage-size', 'specialistaweb/textimage-size'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/be-secure-pw', 'spooner-web/be_secure_pw'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ssch-html5videoplayer', 'ssch/ssch-html5videoplayer'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3-session', 'ssch/t3-session'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/typo3-encore', 'ssch/typo3-encore'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cookieoptin', 'steinbauerit/cookieoptin'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/basic_authentication', 'studiomitte/basic-authentication'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cart-count', 'studiomitte/cart-count'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/html-min', 'studiomitte/html-min'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/klaro', 'studiomitte/klaro'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/redirect2trailingslash', 'studiomitte/redirect2trailingslash'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/replaceli', 'studiomitte/replaceli'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rte-ckeditor-abbr', 'studiomitte/rte-ckeditor-abbr'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sendinblue', 'studiomitte/sendinblue'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/speech-input', 'studiomitte/speech-input'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/thinglink', 'studiomitte/thinglink'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ttaddress-country-relation', 'studiomitte/ttaddress-country-relation'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/urlguard2', 'studiomitte/urlguard2'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ec-styla', 'styladev/typo3'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/libconnect', 'subhh/libconnect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/find', 'subugoe/find'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mail-spool', 'sudhaus7/mail-spool'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/sz_quickfinder', 'sunzinet/sz-quickfinder'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/mailchimp', 'sup7even/mailchimp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/realurl-clearautoconf', 'sup7even/realurl_clearautoconf'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/yaml_configuration', 'supseven/yaml-configuration'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/belogin-images', 'svenjuergens/belogin_images'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/cs-webp', 'svenjuergens/cs-webp'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable_beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/disable-beuser', 'svenjuergens/disable_beuser'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ext-update-info', 'svenjuergens/ext-update-info'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/formhandler', 'svenjuergens/formhandler'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/lock_ts', 'svenjuergens/lock_ts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/minicleaner', 'svenjuergens/minicleaner'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/miniredirect', 'svenjuergens/miniredirect'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/systemplates-to-files', 'svenjuergens/systemplates-to-files'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/weather-widget', 'svenjuergens/weather-widget'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/ws-scss', 'svewap/ws-scss'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/rt-pages-tree-icons', 'syradev/rt_pages_tree_icons'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/dce', 't3/dce'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/file_canonical', 't3/file-canonical'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/form-serialnumber', 't3/form-serialnumber'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3oodle', 't3/t3oodle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/advancedtitle', 't3brightside/advancedtitle'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/favicon', 't3brightside/favicon'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/macrotemplate', 't3brightside/macrotemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/microtemplate', 't3brightside/microtemplate'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/pagelist', 't3brightside/pagelist'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/personnel', 't3brightside/personnel'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/youtubevideo', 't3brightside/youtubevideo'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/examples', 't3docs/examples'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/store_inventory', 't3docs/store-inventory'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/extended-bootstrap-package', 't3graf/extended-bootstrap-package'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/setdefaultauthor', 't3graf/setdefaultauthor'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/femanager_cleverreach', 't3premium/femanager_cleverreach'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/newsslider', 't3s/newsslider'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3sbootstrap', 't3sbs/t3sbootstrap'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_announcements', 't3v/t3v_announcements'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_base', 't3v/t3v_base'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_blueprint', 't3v/t3v_blueprint'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_contacts', 't3v/t3v_contacts'), new \Rector\Composer\ValueObject\RenamePackage('typo3-ter/t3v_content', 't3v/t3v_c