<?php

namespace Mtc\AdminGoogle2fa\Support;

use Illuminate\Support\Facades\URL;
use Illuminate\Http\Request;
use Mtc\Core\Admin\User;

class LegacyHelper
{
    public function check2FAAuthenticated()
    {
        // Check for non laravel admin routes, ignoring product pages
        $url = url()->full();
        if ($this->shouldCheckAuthentication($url)) {
            $user = User::find($_SESSION["adminId"] ?? null);
            // If user not logged in
            if ($user === null) {
                header("Location: /admin/login?" . http_build_query([ 'redirect' => \request()->getRequestUri() ]));
                exit;
            }

            // check if user is authenticated via g2fa
            $verification_url = "http://" . request()->server('SERVER_NAME')
                . str_replace($url, '', route('admin.g2fa.show.verify'));

            if ($user->g2fa_enabled == 1 && empty($_SESSION["g2fa_verified"])) {
                header("Location: {$verification_url}");
                exit;
            }

            // check for force enable g2fa
            if ($user->g2fa_enabled == 0 && $user->g2fa_setting === "required") {
                header("Location: {$verification_url}");
                exit;
            }
        }
    }

    private function shouldCheckAuthentication($url)
    {
        return strpos($url, 'admin') !== false
            && strpos($url, 'product/') === false
            && strpos($url, 'google2fa') === false
            && strpos($url, 'google2fa/verify') === false
            && strpos($url, 'login') === false
            && strpos($url, 'logout') === false;
    }
}
