# Admin Area Google Two-Factor Authentication

This package provides Google 2FA for the admin area.

## Note
You have to install `ImageMagick` on your server if not installed.

## Setup
1. Install the package via composer
```bash
composer require mtcmedia/admin-google2fa
```

2. Publish the configuration file.
```bash
php artisan vendor:publish --tag=config
```
The configuration file will be published into `config/admin-google2fa.php`. Configure as desired prior to running the installer below.


3. Run the configuration command to complete installation.
```bash
php artisan admin-google2fa:install
```

The above command will:
- Run migrations.
- Run seeders.
- Clear application cache.


4. Add the `Google2faMiddleware::class` to `auth` middleware group in `Http/Kernel.php`


5. For legacy URLs to be checked as well, call `check2FAAuthenticated()` from `Supprt\LegacyHelper` in `core/includes/legacy.php`



## Structure

This package adds three columns for managing user authentication at user level:
- `g2fa_secret` for storing the google secret. (This value is hashed for max security).
- `g2fa_setting` sourced from the config file, sets whether 2FA is optional or required. If it is required, users are forced to set it up when they log in.
- `g2fa_enabled` toggles on and off as user 2FA is enabled or disabled.

These ultimately manage the service.

A sub menu is created under `Admin Users` to manage the service including set up, activation and deactivation (for mtc only).
