<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddGoogle2faColumnToAdminUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('admin_users', function (Blueprint $table) {
            // add a text column in the admin_users table for the google2fa_secret
            $table->text('g2fa_secret');
            $table->string('g2fa_setting')->default(config('admin-google2fa.setting'));
            $table->boolean('g2fa_enabled')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('admin_users', function (Blueprint $table) {
            // drop the column if the migration is rolled back
            $table->dropColumn('g2fa_enabled');
            $table->dropColumn('g2fa_secret');
            $table->dropColumn('g2fa_setting');
        });
    }
}
