<?php


namespace Mtc\AdminGoogle2fa\Seeds;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use Mtc\Core\Admin\Menu;
use Spatie\Permission\Models\Permission;
use Mtc\Core\Admin\Role;

class AdminGoogle2faInstallSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this
            ->seedSubMenu()
            ->addPermissionToAdminRole();
    }


    /**
     * Seed Admin menu
     */
    public function seedSubMenu(): AdminGoogle2FaInstallSeeder
    {
        collect($this->getSubMenu())
            ->each(function ($sub_menu_entry) {
                Menu::create($sub_menu_entry);
            });

        return $this;
    }

    /**
     * Get Data for Admin Menu entries
     *
     * @return array
     */
    protected function getSubMenu(): array
    {
        return [
            [
                "sub_id" => '7',
                "title" => "Google 2FA",
                "path" => "/admin/google2fa",
                "activePath" => "/admin/google2fa",
                'icon' => '',
            ],
        ];
    }

    public function addPermissionToAdminRole()
    {
        $role = Role::findByName('Administrator');
        $role->givePermissionTo('google-2fa');
        return $this;
    }
}
