<?php


namespace Mtc\AdminGoogle2fa\Support;

use Illuminate\Support\Facades\URL;
use Illuminate\Http\Request;
use Mtc\Core\Admin\User;

class LegacyHelper
{
    public function check2FAAuthenticated()
    {
        // Check for non laravel admin routes, ignoring product pages
        $url = url()->full();
        if ( strpos($url,'admin' ) !== false
            && strpos($url,'product/') === false
            && strpos($url,'google2fa') === false
            && strpos($url,'google2fa/verify') === false
            && strpos($url,'login') === false
            && strpos($url,'logout') === false) {

            $user = User::find($_SESSION["adminId"]);
            // check if user is authenticated via g2fa
            if ( $_SESSION["g2fa_verified"] == null && $user->g2fa_enabled == 1 ) {
                header("Location: http://" . request()->server('SERVER_NAME') . str_replace($url, '', route('admin.g2fa.show.verify')));
                exit;
            }

            // check for force enable g2fa
            if ( $user->g2fa_enabled == 0 && $user->g2fa_setting == "required" ) {
                header("Location: http://" . request()->server('SERVER_NAME') . str_replace($url, '', route('admin.g2fa.settings')));
                exit;
            }
        }
    }
}