<?php

namespace Mtc\AdminGoogle2fa\Console;

use Illuminate\Console\Command;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\File;

class InstallAdminGoogle2fa extends Command
{
    protected $signature = "admin-google2fa:install";

    protected $description = "Install the Google2fa Component for Admin Area";

    public function handle()
    {
        $this->info('Installing AdminGoogle2faPackage ...');

        $this->info('Running Service Providers  ...');
        $this->call('vendor:publish', [
            '--provider' => "Mtc\AdminGoogle2fa\Providers\AdminGoogle2faServiceProvider",
        ]);

        $this->info('Running Migrations  ...');
        $this->call("migrate");

        $this->info('Running Seeders  ...');
        $this->call("db:seed", [
            '--class' => "Mtc\AdminGoogle2fa\Seeds\AdminGoogle2faInstallSeeder",
        ]);


        $this->info('Clearing Cache  ...');
        $this->call('cache:clear');

        $this->info('Installed AdminGoogle2faPackage!');
    }
}
