<?php

namespace Mtc\AdminGoogle2fa\Providers;

use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Mtc\AdminGoogle2fa\Console\InstallAdminGoogle2fa;
use Mtc\AdminGoogle2fa\Http\Middleware\Google2faMiddleware;
use Illuminate\Http\Request;
use Mtc\AdminGoogle2fa\Listeners\NotifyUserOfG2FAFeature;

/**
 * Class AdminGoogle2faServiceProvider
 *
 * @package Mtc\AdminGoogle2fa
 */
class AdminGoogle2faServiceProvider extends ServiceProvider
{
    /**
     * Register service
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/admin-google2fa.php', 'admin-google2fa');

        // Register service providers
        collect(config('admin-google2fa.service_providers', []))
            ->each(function ($service_provider) {
                $this->app->register($service_provider);
            });

        /*
         * Add google2fa middleware to web middleware
         */
        $router = $this->app->make(Router::class);
        $router->pushMiddlewareToGroup('auth', Google2faMiddleware::class);
    }

    /**
     * Boot (start) service
     *
     * This is done second - here you add functionality that is provided by the service
     * - Add routing / translations / views / commands
     * - Add publishable content
     * - Define additional functionality per necessity
     * @return mixed
     */
    public function boot()
    {

        /*
         * Load languages and templates
         */
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'example');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        if ($this->app->runningInConsole()) {
            // Migrations
            $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');

            // Publish config
            $this->publishes([
                dirname(__DIR__, 2) . '/config/admin-google2fa.php' => config_path('admin-google2fa.php'),
            ], 'config');

            // Register install command
            $this->commands([
                InstallAdminGoogle2fa::class,
            ]);
        }
    }
}
