<?php

namespace Mtc\AdminGoogle2fa\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Mtc\AdminGoogle2fa\Support\Google2FAAuthenticator;

class Google2faMiddleware
{
    protected $except = [
        'admin/logout',
        'admin/google2fa/verify',
        'admin/login',
        'admin/forgot-password',
        'admin/reset-password',
    ];

    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $authenticator = app(Google2FAAuthenticator::class)->boot($request);

        if (in_array($request->path(), $this->except)) {
            return $next($request);
        }

        if ($authenticator->isAuthenticated()) {
            if ($this->mustActivateOTP()) {
                return redirect()->route("admin.g2fa.settings");
            }

            return $next($request);
        }

        return redirect()->route("admin.g2fa.show.verify");
    }

    public function mustActivateOTP(): bool
    {
        return Auth::user()->g2fa_enabled == 0 && Auth::user()->g2fa_setting === "required";
    }
}
