<?php
    
    namespace Mtc\AdminShippingMethod\Helper;
    
    use Magento\Store\Model\ScopeInterface;
    use Magento\Sales\Api\OrderRepositoryInterface;
    use Magento\Framework\App\Config\ScopeConfigInterface;
    
    /**
     * Admin Shipping method data helper
     *
     * @api
     *
     * @SuppressWarnings(PHPMD.TooManyFields)
     * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
     * @since                                          100.0.2
     */
class Data
{
        
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;
        
    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    protected $orderRepository;
        
    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Sales\Api\OrderRepositoryInterface        $orderRepository
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        OrderRepositoryInterface $orderRepository
    ) {
        $this->orderRepository  = $orderRepository;
        $this->scopeConfig = $scopeConfig;
    }
        
    /**
     * @return \Magento\Sales\Api\OrderRepositoryInterface
     */
    public function getOrder()
    {
        return $this->orderRepository;
    }
    
    /**
     * @param int $storeId
     *
     * @return mixed
     */
    public function getPreSelect(int $storeId)
    {
        return $this->scopeConfig->isSetFlag(
            'carriers/adminshippingmethod/pre_select',
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }
    
    /**
     * @param int $storeId
     *
     * @return mixed
     */
    public function getCreatInvoice(int $storeId)
    {
        return $this->scopeConfig->isSetFlag(
            'carriers/adminshippingmethod/createinvoice',
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }
    
    /**
     * @param int $storeId
     *
     * @return mixed
     */
    public function getCreatShipment(int $storeId)
    {
        return $this->scopeConfig->isSetFlag(
            'carriers/adminshippingmethod/createshipment',
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }
    
    /**
     * @param int $storeId
     *
     * @return mixed
     */
    public function getName(int $storeId)
    {
        return $this->scopeConfig->getValue(
            'carriers/adminshippingmethod/name',
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }
        
    /**
     * @param int $storeId
     *
     * @return mixed
     */
    public function getTitle(int $storeId)
    {
        return $this->scopeConfig->getValue(
            'carriers/adminshippingmethod/title',
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }
    
    /**
     * @param int $storeId
     *
     * @return mixed
     */
    public function getError(int $storeId)
    {
        return $this->scopeConfig->getValue(
            'carriers/adminshippingmethod/specificerrmsg',
            ScopeInterface::SCOPE_STORE,
            $storeId
        );
    }
}
