<?php

return [
    'settings' => [
        'auction_enabled'                      => true,
        'lot_registration_enabled'             => true,
        'anti_sniping_enabled'                 => true,
        'anti_sniping_cutoff_time'             => 10,
        'anti_sniping_extend_minutes'          => 10,
        'anti_sniping_max_overtime_hours'      => 2,
        'max_complementary_lots'               => 4,
        'auctions_live_menu_id'                => 2,
        'default_buyer_commission_percentage'  => 10,
        'default_seller_commission_percentage' => 5,
        'default_seller_commission_limit'      => 0,
        'watchlist_enabled' => true,
        'lot_storage_enabled' => true,
        'late_lot_payment_fees_enabled' => true,
        'registration_fee_for_bidders' => true,
        'registration_fee_for_sellers' => false,
        'barcode_look_up' => false,
        'minimum_bid_value' => 0,
        'minimum_bid_value_per_lot' => 0,
        'show_batch_add_lots_page' => false,
        'name_lookup_enabled' => true,
        'default_weight' => 2, //in kg
        'lot_id_to_include_auction_id' => false,
        'recently_viewed_lots_max' => 10,
        'bid_style' => 'input', // valid options: input and select
        'live_menu_id' => 30,
        'default_late_payment_fee_percentage' => 3,
    ],
    'late_payment_fee'                     => [
        'payment_workdays' => 3,
        'fee_percentage'   => 0.04,
    ],
    'storage'                              => [
        'days_allowance'   => 90,
        'delivery_id'      => 7,
        'late_fee_per_day' => 1,
    ],
    'insurance_percentage'                 => 0.04,
    'property_types_with_images'           => [

    ],
    'property_types_with_description'      => [

    ],
    'property_types_with_landing_pages'    => [//
    ],
    'buyer_commission_tiers'               => '',/*
    'buyer_commission_tiers' => [
        [
            'min_highest_bid' => 0,
            'max_highest_bid' => 999999,
            'buyer_commission_percentage' => 10,
        ],
    ],*/
    'bank_transfer_details'                => [
        'accounts'                  => [
            'USD' => '',
            'GBP' => '',
            'CNY' => '',
        ],
        'account_number'            => '',
        'swift_code'                => '',
        'bank_name'                 => '',
        'bank_address'              => '',
        'accepted_currencies'       => [
            'USD',
            'GBP',
            'RMB',
            'EUR',
        ],
        'currencies_account_number' => [
            'USD' => '',
            'GBP' => '',
            'CNY' => '',
        ],
    ],
    'credit_card_surcharge_percentage'     => 0.03,

    /*
    |--------------------------------------------------------------------------
    | Service bootstrap
    |--------------------------------------------------------------------------
    |
    | Allow changing event and routing service providers to customize functionality
    |
    */
    'routing'                              => \Mtc\Auction\Providers\AuctionRoutesServiceProvider::class,
    
    'fees' => [
      'registration' => [
          'key' => 'REGISTRATION_FEE',
          'label' => 'Registration Fee',
          'default_value' => 5.50,
      ],
      'reserve' => [
          'key' => 'RESERVE_FEE',
          'label' => 'Reserve Fee',
          'default_value' => 10.00,
      ]  
    ],
    
    'membership_fee' => 4.99,
    
    'max_complementary_lots' => 5,

    'lots' => [
        'defer_lot_registration_fees' => true,
        'defer_lot_reserve_fees' => true,
        'identifier'            => 'id',
        'purchase_plu_defaults' => [
            'LOT_PURCHASE_PLU'        => 'LOT_PURCHASE',
            'LOT_RELIST_PLU'          => 'LOT_RELIST_FEE',
            'LOT_REGISTER_RELIST_PLU' => 'LOT_REGISTER_RELIST_FEE',
            'LOT_RESERVE_RELIST_PLU'  => 'LOT_RESERVE_RELIST_FEE',
            'LOT_REGISTER_PLU'        => 'LOT_FEE',
            'LOT_RESERVE_PLU'         => 'RESERVE_FEE',
        ],
    ],
    'logging' => [
        'path' => env('AUCTION_PLATFORM_LOGGING_PATH', false),
        'name' => env('AUCTION_PLATFORM_LOGGING_NAME', false),
        'file' => env('AUCTION_PLATFORM_LOGGING_FILE', false),
    ],
    'default_lot_image_path' => '/sites/whisky-auction-house/images/logo.svg',
];
