<?php
/**
 * Auction Images
 *
 * Image folders must follow the format below.
 * The main $image_folders array is passed to Twig as a global variable
 *
 *
 *  $image_folders['unique_group_name'] = [
 *      'size_name' => [
 *          'path'                  => 'images/path',   // Path to images from public_html. No surrounding slashes.
 *          'width'                 => 2000,            // (optional if height is supplied) (int) If you provide a width but not the height it will resize the width and allow the height to strech however long
 *          'height'                => 2000,            // (optional if width is supplied) (int) If you provide a height but not the width it will resize the height and allow the width to strech however long
 *          'crop'                  => false,           // (optional) (default: true) (bool) Weather or not to crop image.
 *          'quality'               => 80,              // (optional) (default: 80) (int) Quality of the resized image.
 *          'crop_position'         => "middle"         // (optional) (default: middle) (string: top_left/top_center/top_right/middle_left/middle/middle_right/bottom_left/bottom_center/bottom_right)
 *                                                      // Position of the crop.
 *          'optimize_lossless'     => true             // (optional) (default: true) (bool) Allows to override IMAGE_OPTIMISE_LOSSLESS admin setting.
 *          'skip'                  => false            // (optional) (default: false) (bool) If true it will skip resizing this size. Used for "original" size
 *      ]
 *  ];
 *
 * For the recrop feature to work, the "originals" sub array must exist.
 * For recrop to work correctly all cropped images in an array must have the same aspect ratio.
 * A solution may be developed later for different aspect ratios.
 *
 */
$image_folders['auction_images'] = [
    'originals' => [
        'path'   => 'uploads/images/auction/originals',
        'width'  => 2000,
        'height' => 2000,
        'forced' => false,
        'crop'   => false,
    ],
    'normal'    => [
        'path'   => 'uploads/images/auction',
        'width'  => 1160,
        'height' => 349,
        'forced' => false,
        'crop'   => false,
    ],
    'banner'    => [
        'path'   => 'uploads/images/auction/banner',
        'width'  => 1900,
        'height' => 600,
        'forced' => false,
        'crop'   => true,
    ],
    'thumbs'    => [
        'path'   => 'uploads/images/auction/thumbs',
        'width'  => null,
        'height' => 280,
        'forced' => false,
        'crop'   => false,
    ],
];

$image_folders['lot_images'] = [
    'originals' => [
        'path'   => 'uploads/images/lots/originals',
        'width'  => 2500,
        'height' => 2500,
        'forced' => false,
        'crop'   => false,
    ],
    'mini'      => [
        'path'   => 'uploads/images/lots/mini',
        'width'  => 50,
        'height' => 50,
        'forced' => false,
        'crop'   => true,
    ],

    'smallthumbs' => [
        'path'   => 'uploads/images/lots/smallthumbs',
        'width'  => 100,
        'height' => 124,
        'forced' => false,
        'crop'   => false,
    ],

    'thumbs' => [
        'path'   => 'uploads/images/lots/thumbs',
        'width'  => null,
        'height' => 280,
        'forced' => false,
        'crop'   => false,
    ],

    'large'     => [
        'path'   => 'uploads/images/lots/large',
        'width'  => null,
        'height' => 685,
        'forced' => false,
        'crop'   => true,
    ],
    'verylarge' => [
        'path'   => 'uploads/images/lots/verylarge',
        'width'  => 1200,
        'height' => 1200,
        'forced' => false,
        'crop'   => false,
    ],
];
