## Readme

### Environments variable

Update .env with these variables

```text
LOG_LEVEL=debug
AUCTION_PLATFORM_LOGGING_PATH=/home2/stawhisk/logs/auction-platform/
AUCTION_PLATFORM_LOGGING_NAME=auction-platform
AUCTION_PLATFORM_LOGGING_FILE=auction-platform.log
```


### Auction platform countdown timer.

At the moment, it may not be possible to implement as part of the Auction platform.

Manual integration needs to be done to include the auction countdown timer.

1. Add a new 'AUCTION_PLATFORM' setting value in the 'config/settings.php'

![img.png](readme-assets/img.png)

2. Add new conditional checking for the 'AUCTION_PLATFORM' in the 'sites/xxxx/templates/layouts/default.twig' and 'sites/xxxx/templates/includes/secondary_menu_navigation.twig'

![img2.png](readme-assets/img2.png)

![img.png](readme-assets/img3.png)

3. Copy 'packages/mtcmedia/auction-platform/resources/js/assets/mtc_get_auction_countdown.js' to 'sites/xxxx/js/site_scripts/mtc_get_auction_countdown.js'

![img.png](readme-assets/img4.png)

![img.png](readme-assets/img5.png)

4. Copy 'packages/mtcmedia/auction-platform/resources/templates/assets/countdown.twig' to 'sites/xxxx/templates/Auction/auctions/countdown.twig'

![img.png](readme-assets/img6.png)

![img.png](readme-assets/img7.png)

5. Recompile FE assets
```bash
npm run prod
```
6. Run seeder
```bash
php artisan db:seed --class='Mtc\Auction\Seeds\AuctionSeeder'
```

7. Register Cron
```text
*	*	*	*	*	/opt/alt/php80/usr/bin/php ~/public_html/artisan schedule:run >> /dev/null 2>&1
```
