<?php

use Illuminate\Routing\Router;

$router->group([
    'namespace' => 'Mtc\Auction\Http\Controllers',
], function (Router $router) {
    
    $router->post('shipping-rates', 'AuctionController@shippingBreakdownGetRates');
    
    $router->get('purchase-lots', 'LotController@buyLots');
    
    //auction and auction filter routes routes
    // TODO - Buy it Now options. Likely never used in the old system
    $router->get('buy-it-now', 'AuctionController@index')
           ->where('any', '.*');
    $router->get('buy-it-now' . '/{any}', 'AuctionController@index')
           ->where('any', '.*');
    $router->post('buy-it-now', 'AuctionController@index')
           ->where('any', '.*');
    $router->post('buy-it-now' . '/{any}', 'AuctionController@index')
           ->where('any', '.*');
    $router->get('live-auction', 'AuctionController@index')
           ->where('any', '.*');
    $router->get('live-auction' . '/{any}', 'AuctionController@index')
           ->where('any', '.*');
    $router->post('live-auction', 'AuctionController@index')
           ->where('any', '.*');
    $router->post('live-auction' . '/{any}', 'AuctionController@index')
           ->where('any', '.*');
    $router->get('my-watchlist', 'AuctionController@index')
           ->where('any', '.*');
    $router->get('my-watchlist' . '/{any}', 'AuctionController@index')
           ->where('any', '.*');
    $router->post('my-watchlist', 'AuctionController@index')
           ->where('any', '.*');
    $router->post('my-watchlist' . '/{any}', 'AuctionController@index')
           ->where('any', '.*');
    /*if (AUCTION_LIST_PAGE_ENABLED === true) {
        $router->get('past-auctions', 'AuctionController@list');
    } else {
        $router->get('past-auctions', 'AuctionController@index');
    }*/
    $router->get('past-auctions', 'AuctionController@list');
    $router->post('past-auctions', 'AuctionController@index');
    $router->get('past-auctions/search', 'AuctionController@index');
    $router->get('past-auctions' . '/{any}', 'AuctionController@index');
    $router->post('past-auctions' . '/{any}', 'AuctionController@index');
    
    
    //bid routes
    $router->get('bids/{lot_id}', 'BidController@show');
    $router->post('bids/{lot_id}', 'BidController@store');
    $router->post('bids-validate/{lot_id}', 'BidController@validateBid');
    $router->post('bids/{lot_id}/history', 'BidController@history');

    //lot routes
    $router->get('lot-{lot_id}/{lot_name}', 'LotController@show');
    $router->get('lot-{lot_id}/{lot_name}/{search}/{previous_search?}', 'LotController@show');
    $router->post('lot-{lot_id}/{lot_name}/complementary', 'LotController@getComplementary');
    $router->get('lot-{lot_id}/{lot_name}/buy-it-now', 'LotController@buyLot');
    $router->post('lot-{lot_id}/{lot_name}/update-reserve', 'LotController@updateReserve');
    $router->post('featured-lots', 'LotController@featured');

    if (config('auction.settings.lot_storage_enabled') === true) {
        $router->get('members/my-storage', 'StorageController@index')->name('members.my-storage');
        $router->post('members/my-storage', 'StorageController@show');
        $router->put('members/my-storage', 'StorageController@ship');
    }

    if (config('auction.settings.watchlist_enabled') === true) {
        $router->get('members/my-watchlist', 'WatchlistController@index')->name('members.my-watchlist');
        $router->post('members/my-watchlist', 'WatchlistController@index');
        $router->get('watchlist/{lot_id}', 'WatchlistController@show');
        $router->post('watchlist/{lot_id}', 'WatchlistController@update');
    }
    
    if (config('auction.settings.lot_registration_enabled') === true) {
        $router->get('sell-lots', 'LotRegistrationController@index')->name('members.sell_lots');
        $router->post('sell-lots', 'LotRegistrationController@store');
    }
    
    //customer facing members area
    $router->group([
        'prefix'     => 'members',
        'as'         => 'members.',
        'middleware' => [
            \Mtc\Members\Http\Middleware\LoggedInMember::class
        ],
    ], function (Router $router) {
        // List & search of lots user is selling
        $router->get('my-lots', 'AuctionMemberController@sellerLots')
               ->name('sellers_lots');
        $router->post('my-lots', 'AuctionMemberController@sellerLots');
        $router->get('my-lots/{lot_id}/receipt', 'AuctionMemberController@receipt');

        // List & Search of lots user is bidding
        $router->post('my-bids/winning', 'AuctionMemberController@myWinningBids');
        $router->post('my-bids/outbid', 'AuctionMemberController@myOutbidBids');
        $router->get('my-bids', 'AuctionMemberController@myBids')->name('my_bids');
        $router->post('my-bids', 'AuctionMemberController@myBids');
        $router->get('my-bids/winning/sum', 'AuctionMemberController@myWinningBidsSum');
        $router->get('my-bids/selling/sum', 'AuctionMemberController@mySellingLotsSum');

        // List & Search of winnings
        $router->get('my-winnings', 'AuctionMemberController@myWinnings')->name('my_winnings');
        $router->post('my-winnings', 'AuctionMemberController@myWinnings');
        $router->get('my-winnings/{lot_id}/invoice', 'AuctionMemberController@invoice');

        $router->get('pay-membership-fee', 'AuctionMemberFeesController@addToBasket');
    });
    
    // admin routes
    $router->group([
        'prefix'     => 'admin',
        'as'         => 'admin.',
        'middleware' => [
            'auth',
        ],
    ], function (Router $router) {
        $router->resource('auctions', 'Admin\AuctionController');
        $router->get('auctions/{auction_id}/delete', 'Admin\AuctionController@destroy');
        $router->get('auctions/export/stats', 'Admin\AuctionController@exportToCSV');
        
        //Email Template Testing Suite
        $router->get('auction/email-templates', 'Admin\AuctionEmailViewerController@index');
        $router->get('auction/email-tester', 'Admin\AuctionEmailTesterController@index');
        $router->post('auction/email-tester', 'Admin\AuctionEmailTesterController@send');

        //Membership Fees
        $router->resource('auction/member-fees', 'Admin\AuctionMemberFeesController');
        
        //Price Trends
        $router->resource('price-trends', 'Admin\PriceTrendController');
        $router->resource('price-trends-entries', 'Admin\PriceTrendEntryController');
        $router->get('price-trends/{price_trend}/create-entry', 'Admin\PriceTrendEntryController@createForPriceTrend');

        // Bid Admin
        $router->resource('bids/increments', 'Admin\BidIncrementController');
        $router->resource('bids', 'Admin\BidController');
        $router->get('bids/{bid_id}/delete', 'Admin\BidController@destroy');

        // Lot Delivery
        $router->get('lot-pickup/{method_id}/delete', 'Admin\LotPickupController@destroy');
        $router->resource('lot-pickup', 'Admin\LotPickupController');

        // Lot Collection Points
        $router->get('lot-collection-points/{method_id}/delete', 'Admin\LotCollectionPointController@destroy');
        $router->resource('lot-collection-points', 'Admin\LotCollectionPointController');

        // Lot admin
        $router->group([
            'prefix' => 'lots',
            'as'     => 'lots.', 
        ], function (Router $router) {
            $router->get('defaults', 'Admin\LotController@loadDefaults');
            $router->post('bulk-update', 'Admin\LotController@bulkActions');
            $router->post('search', 'Admin\LotController@search');
            $router->post('lookup', 'Admin\LotController@lookup');
            
            $router->post('recalculate-values', 'Admin\LotController@recalculateValues');
            
            // Lot Images
//            $router->get('{lot}/images', 'Admin\LotImageController@index');
//            $router->post('{lot}/images', 'Admin\LotImageController@store');
            $router->get('{lot}/images/show', 'Admin\LotImageController@show');
            $router->post('{lot}/images/{image}/set-zoom', 'Admin\LotImageController@setZoom');
            $router->post('{lot}/images/{image}/set-default', 'Admin\LotImageController@setDefault');
            $router->post('{lot}/images/{image}/set-hover', 'Admin\LotImageController@setHover');
            $router->resource('{lot}/images', 'Admin\LotImageController')->except(['edit', 'create', 'show']);



            $router->get('storage/removed', 'Admin\LotStorageController@removed');
            $router->post('storage/move', 'Admin\LotStorageController@move');
            $router->resource('storage', 'Admin\LotStorageController', [
                'only' => [
                    'index',
                    'edit',
                    'update',
                ],
            ]);

            $router->resource('storage-location', 'Admin\LotStorageLocationController', [
                'only' => [
                    'index',
                    'edit',
                    'create',
                    'update',
                    'store',
                ],
            ]);
            
            $router->get('admin/storage/{storage_lot_id}/delete', 'Admin\LotStorageController@destroy');
            $router->resource('custom-fields', 'Admin\LotCustomFieldController')
                   ->middleware([
                       'permission:custom-fields'
                   ]);

            $router->resource('custom-field-sets', 'Admin\LotCustomFieldSetController')
                   ->middleware([
                       'permission:custom-fields'
                   ]);

            $router->get('custom-field-sets/{custom_field_set}/load-fields', 'Admin\LotCustomFieldSetController@loadFields');
            
            $router->get('importer', 'Admin\AuctionDataImporterController@index');
            $router->post('importer', 'Admin\AuctionDataImporterController@import');
        });
        
        $router->resource('lots', 'Admin\LotController');
        $router->get('lots/{lot_id}/delete', 'Admin\LotController@destroy');
        $router->post('lots/{lot_id}/fees/create', 'Admin\LotController@createFee');
        $router->post('lots/{lot_id}/fees/update', 'Admin\LotController@updateFee');
        $router->get('lots/{lot_id}/fees/{fee_id}/delete', 'Admin\LotController@destroyFee');
    });

    $router->post('toggle-lot-insurance', 'LotBasketInsuranceController@store');
    
    $router->get('auction-feed', 'AuctionCalendarController@index');
    
    foreach(\Mtc\Core\Node::where('nodeable_type', 'Mtc\Auction\Auction')->get() as $auction){
        if(!empty($auction->url)) {
            $router->get($auction->url, 'AuctionController@index');
            $router->post($auction->url, 'AuctionController@index');
        }
    }
    
});