<?php

/**
 * Clone of Custom Fields Sets for Products.
 * Old Set up used the exact same classes and made it so that Proucts and Lots had to share
 * In this new set up we cannot have that and so Lots get their own custom fields
 *
 * @version 03/08/23
 * @author Jack Donaldson <jack.donaldson@mtc.co.uk>
 */

namespace Mtc\Auction;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;

/**
 * Custom Field Set Eloquent model.
 * Implements Shop Custom Field Set management
 *
 * @version 29/09/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class CustomFieldSet extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'auction_custom_fields_sets';

    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'default'
    ];

    /**
     * Define relationship with fields assigned to this Set
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function fields()
    {
        return $this->hasMany(CustomFieldSetField::class, 'set_id');
    }

/*    public function categories()
    {
        return $this->hasMany(Category::class, 'custom_field_set_id');
    }*/

    public function customFields(): BelongsToMany
    {
        return $this->belongsToMany(CustomField::class, 'auction_custom_fields_sets_fields', 'set_id', 'custom_field_id')
            ->withPivot([
                'required',
                'lots',
                'variations',
                'filter',
            ]);
    }

    /**
     * Auction list in id => name format
     *
     * @return Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Database\Query\Builder[]|Collection
     */
    public static function idNameList()
    {
        return self::query()
                   ->pluck('name', 'id');
    }
}
