<?php

namespace Mtc\Auction\Filter;

use Illuminate\Support\Facades\DB;
use Mtc\Auction\Bid;
use Mtc\Auction\Lot;

/**
 * Class SortByMostRecent
 *
 * @package Mtc\Modules\Auction\Classes\Filter
 */
class SortByMostRecent extends BaseSort
{
    /**
     * @param string $direction
     * @return mixed
     */
    public function handle($direction = 'desc')
    {
        $bid_table = (new Bid)->getTable();
        $lot_table = (new Lot)->getTable();

        $sub_query = DB::table($bid_table)
            ->orderBy('bid', 'desc')
            ->select('created_at')
            ->whereRaw("{$lot_table}.id = {$bid_table}.lot_id")
            ->limit(1);

        return $this->query
            ->select("{$lot_table}.*")
            ->selectSub($sub_query, 'latest_bid_time')
            ->orderBy('latest_bid_time', $direction);
    }
}