<?php

namespace Mtc\Auction\Filter;

use Illuminate\Support\Facades\DB;
use Mtc\Auction\Bid;
use Mtc\Auction\Lot;

/**
 * Class SortByPopularity
 *
 * @package Mtc\Modules\Auction\Classes\Filter
 */
class SortByPopularity extends BaseSort
{
    /**
     * @param string $direction
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Query\Builder
     */
    public function handle($direction = 'desc')
    {
        $bid_table = (new Bid)->getTable();
        $lot_table = (new Lot)->getTable();

        $sub_query = DB::table($bid_table)
            ->selectRaw('count(bid)')
            ->whereRaw("{$lot_table}.id = {$bid_table}.lot_id")
            ->limit(1);

        return $this->query
            ->select("{$lot_table}.*")
            ->selectSub($sub_query, 'bid_count')
            ->orderBy('bid_count', $direction);
    }
}