<?php

namespace Mtc\Auction\Filter;

use Illuminate\Support\Facades\DB;
use Mtc\Auction\Bid;
use Mtc\Auction\Filter;
use Mtc\Auction\Lot;

/**
 * Class SortByRelevance
 *
 * @package Mtc\Modules\Auction\Classes\Filter
 */
class SortByRelevance extends BaseSort
{
    /**
     * @param string $direction
     * @return mixed
     */
    public function handle($search_terms = '')
    {
        $bid_table = (new Bid)->getTable();
        $lot_table = (new Lot)->getTable();

        $sub_query = DB::table($bid_table)
            ->orderBy('bid', 'desc')
            ->select('bid')
            ->whereRaw("{$lot_table}.id = {$bid_table}.lot_id")
            ->limit(1);

        $search_like = '%' . str_replace(' ', '%', $search_terms) . '%';


        return $this->query
            ->select("{$lot_table}.*")
            ->selectRaw('(((MATCH (`name`) AGAINST (' . DB::getPdo()->quote(Filter::fullTextWildcards($search_terms)) . ')) * 30) + ((`name` LIKE ' . DB::getPdo()->quote($search_like) . ') * 300) + ((MATCH (`description`) AGAINST (' . DB::getPdo()->quote(Filter::fullTextWildcards($search_terms)) . ')) * 1)) AS relevance')
            ->orderBy('relevance', 'desc')
            ->selectSub($sub_query, 'bid_value')
            ->orderBy('bid_value', 'desc');
    }

    /**
     * Escape search terms
     *
     * @param $search_terms
     * @return string
     */
    protected function escapedSearchTerms($search_terms)
    {
        return collect(explode(' ', $search_terms))
            ->map(function ($term) {
                return DB::getPdo()->quote($term);
            })
            ->implode(' ');
    }
}
