<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Mtc\Auction\Auction;
use Mtc\Auction\AuctionMember;
use Mtc\Auction\Lot;
use Mtc\Auction\Bid;

class AuctionEmailViewerController extends Controller
{

    public function index(){
        $emails = [
            [
                'title' => env('APP_NAME') . " - Lots Submitted",
                'path' => 'seller_lots_submitted.twig',
                'content' => $this->lotsSubmittedExample(),
            ],
            [
                'title' => env('APP_NAME') . " - Auction Ended, You've won!",
                'path' => 'won.twig',
                'content' => $this->wonExample(),
            ],
            [
                'title' => env('APP_NAME') . " - Auction Now Live",
                'path' => 'seller_auction_live.twig',
                'content' => $this->auctionLiveExample(),
            ],
            [
                'title' => env('APP_NAME') . " - Auction Ended",
                'path' => 'seller_auction_end.twig',
                'content' => $this->auctionEndedExample(),
            ],
            [
                'title' => 'Auction for lots in your watchlist has ended on ' . env('APP_NAME'),
                'path' => 'watchlist_end.twig',
                'content' => $this->auctionWatchlistEndExample(),
            ],
            [
                'title' => __('seller.relist_return.email_notification_subject', [ 'site' => env('APP_NAME')]),
                'path' => 'seller_relist_return_email.twig',
                'content' => $this->relistReturnExample(),
            ],
            [
                'title' => "Reminder to input Lot tracking details on " . env('APP_NAME'),
                'path' => 'courier_details_reminder.twig',
                'content' => $this->courierReminderExample(),
            ],
            [
                'title' => "Lot Courier details updated on " . env('APP_NAME'),
                'path' => 'bid_accepted_notification.twig',
                'content' => $this->courierUpdateExample(),
            ],
            [
                'title' => env('APP_NAME') . " - Bid Received",
                'path' => 'bid_accepted_notification.twig',
                'content' => $this->bidExample(),
            ],
            [
                'title' => env('APP_NAME') . " - You've Been Outbid",
                'path' => 'outbid.twig',
                'content' => $this->outbidExample(),
            ],
            [
                'title' => env('APP_NAME') . " - Your bid has increased",
                'path' => 'bid_increase_notification.twig',
                'content' => $this->bidIncreaseExample(),
            ],
            [
                'title' => env('APP_NAME') . ' - A new bid has been placed on your Lot',
                'path' => 'own_lots.twig',
                'content' => $this->bidIncreaseOwnerExample(),
            ],
            [
                'title' => env('APP_NAME') . ' - Lot #12345 Updated',
                'path' => 'client_report_lot_update.twig',
                'content' => $this->clientReportLotUpdateExample(),
            ],
            [
                'title' => env('APP_NAME') . ' - Member Created (NEEDS APPROVED)',
                'path' => 'client_report_member_created.twig',
                'content' => $this->clientReportMemberCreatedExample(),
            ],
            [
                'title' => __('seller.sell.you_have_been_paid'),
                'path' => 'paid_seller.twig',
                'content' => $this->paidSeller(),
            ],
            [
                'title' => env('APP_NAME') . ' - Payment Reminder E-Mail',
                'path' => 'lots_not_paid_reminder.twig',
                'content' => $this->notPaidReminder(),
            ],
            [
                'title' => 'Storage expiring on ' . env('APP_NAME'),
                'path' => 'storage_expiring.twig',
                'content' => $this->storageExpiringExample(),
            ],
            [
                'title' => 'Bank Transfer Invoice Email',
                'path' => 'BankTransfer/emails/payment_information.twig',
                'content' => $this->bankTransferInvoiceEmail(),
            ],
        ];

        $this->page_meta['title'] = 'Auction Emails';
        return template('Auction/admin/emails.twig', [
            'page_meta' => $this->page_meta,
            'emails' => $emails
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function lotsSubmittedExample()
    {
        $lot_list = Lot::query()
                       ->where('status', Lot\Status::REGISTERED)
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $seller = $lot_list->first()->seller;
        return template('Auction/emails/seller_lots_submitted.twig', [
            'lots' => $lot_list,
            'member' => $seller,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function wonExample()
    {
        $winning_lot = Lot::query()
                          ->whereIn('status', Lot\Status::$winning_statuses)
                          ->where('seller_id', '!=', '')
                          ->first();

        $member = $winning_lot->seller;
        $lots = Lot::query()
                   ->where('seller_id', $member->id)
                   ->where('auction_id', $winning_lot->auction_id)
                   ->get();

        return template('Auction/emails/won.twig', [
            'lots' => $lots,
            'member' => $member,
            'purchase_url' => config('app.url') . '/purchase-lots',
            'bank_transfer_details' => config('auction.bank_transfer_details'),
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function bankTransferInvoiceEmail()
    {
        return 'TODO';
        
        /*$order = new \Order(195);

        $insurance = 0;
        $cost_subtotal = $order->getSubtotalCost();
        if ($order->getId()) {
            $insurance = collect($order->surcharges)
                ->filter(function ($surcharge) {
                    return $surcharge->type === 'Insurance';
                })
                ->first();
        }

        $order_items = array_map(function ($item) use ($insurance, $cost_subtotal, $order) {
            $item['lot'] = Lot::query()
                              ->whereHas('purchaseSize', function ($size_query) use ($item) {
                                  return $size_query->where('id', $item['sizeid']);
                              })
                              ->first();

            $item_price = $order->no_vat ? $item['item_price_exvat'] : $item['item_price'];

            if ($insurance) {
                $cost_percentage = $item_price / $cost_subtotal;
                $item['lot']->insurance = $insurance->amount * $cost_percentage;
            } else {
                $item['lot']->insurance = 0;
            }

            $item['lot']->other_fees = $item_price -
                                       $item['lot']->highest_bid -
                                       ($order->no_vat ? $item['lot']->buyer_commission : $item['lot']->buyer_commission_with_vat);

            $item['lot']->total = $item_price + $item['lot']->insurance;

            return $item;
        }, $order->getItems());

        $subtotal = array_sum(array_map(function ($item) {
            return $item['lot']->total;
        }, $order_items));

        //dd($order);
        $page_meta = [
            'title' => 'Payment Processing | ' . config('app.name'),
            'page_title' => 'Payment Details On The Way',
            'page_sub_title' => 'Please see your email for payment details',
        ];

        //dd($order_items);

        return template('BankTransfer/emails/payment_information.twig', [
            'page_meta' => $page_meta,
            'basket_object' => $order,
            'order' => $order, // order details
            'order_items' => $order_items,
            'insurance' => $insurance->amount,
            'subtotal' => $subtotal,
            'member' => AuctionMember::find($order->member),
            'bank_transfer_details' => config('auction.bank_transfer_details'),
            //'tracking_code' => $tracking_code,
        ]);*/
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function auctionLiveExample()
    {
        $auction = Auction::query()
                          ->past()
                          ->inRandomOrder()
                          ->first();

        $lot_list = Lot::query()
                       ->where('auction_id', $auction->id)
                       ->where('seller_id', '!=', '')
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $seller = $lot_list->first()->seller;
        return template('Auction/emails/seller_auction_live.twig', [
            'lots' => $lot_list,
            'member' => $seller,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function auctionEndedExample()
    {
        $auction = Auction::query()
                          ->past()
                          ->inRandomOrder()
                          ->first();

        $lot_list = Lot::query()
                       ->where('auction_id', $auction->id)
                       ->where('seller_id', '!=', '')
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $member = $lot_list->first()->seller;

        $lots_with_no_payout_details = $lot_list
            ->where('payout_details', '')
            ->isNotEmpty();

        return template('Auction/emails/seller_auction_end.twig', [
            'lots' => $lot_list,
            'unsold_lots' => $lot_list->where('status', Lot\Status::NOT_SOLD),
            'member' => $member,
            'lots_with_no_payout_details' => $lots_with_no_payout_details,
            'lot_statuses' => Lot\Status::$lot_statuses,
        ]);

    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function auctionWatchlistEndExample()
    {
        $auction = Auction::query()
                          ->past()
                          ->inRandomOrder()
                          ->first();

        $lot_list = Lot::query()
                       ->where('auction_id', $auction->id)
                       ->where('seller_id', '!=', '')
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $seller = $lot_list->first()->seller;
        return template('Auction/emails/watchlist_end.twig', [
            'lots' => $lot_list,
            'member' => $seller,
            'sold_status' => Lot\Status::SOLD,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function relistReturnExample()
    {
        $lot_list = Lot::query()
                       ->where('status', Lot\Status::NOT_SOLD)
                       ->where('seller_id', '!=', '')
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $member = $lot_list->first()->seller;

        return template('Auction/emails/seller_relist_return_email.twig', [
            'lots' => $lot_list,
            'member' => $member,
            'returned_status' => Lot\Status::RETURNED,
        ]);

    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function courierReminderExample()
    {
        $lot_list = Lot::query()
                       ->where('status', Lot\Status::READY)
                       ->where('seller_id', '!=', '')
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $member = $lot_list->first()->seller;

        return template('Auction/emails/courier_details_reminder.twig', [
            'lots' => $lot_list,
            'member' => $member,
            'courier_url' => config('app.url') . '/seller/courier-details?' . http_build_query([
                                                                                          'lot_ids' => $lot_list->pluck('id')->toArray()
                                                                                      ]),
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function courierUpdateExample()
    {
        $lot_list = Lot::query()
                       ->where('status', Lot\Status::READY)
                       ->where('seller_id', '!=', '')
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $member = $lot_list->first()->seller;

        return template('Auction/emails/courier_details_update.twig', [
            'lots' => $lot_list,
            'member' => $member,
            'data' => [
                'courier_name' => 'UPS',
                'tracking_code' => '123128371283127',
            ],
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function bidExample()
    {
        $bid = Bid::query()->latest()->first();
        return template('Auction/emails/bid_accepted_notification.twig', [
            'top_bid' => $bid,
            'lot' => $bid->lot,
            'member' => $bid->member,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function outbidExample()
    {
        $bid = Bid::query()->latest()->first();
        return template('Auction/emails/outbid.twig', [
            'top_bid' => $bid,
            'lot' => $bid->lot,
            'member' => $bid->member,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function bidIncreaseExample()
    {
        $bid = Bid::query()->latest()->first();
        return template('Auction/emails/bid_increase_notification.twig', [
            'top_bid' => $bid,
            'lot' => $bid->lot,
            'member' => $bid->member,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function bidIncreaseOwnerExample()
    {
        $bid = Bid::query()->latest()->first();
        return template('Auction/emails/own_lots.twig', [
            'top_bid' => $bid,
            'lot' => $bid->lot,
            'member' => $bid->member,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function clientReportLotUpdateExample()
    {
        $lot = Lot::query()
                  ->inRandomOrder()
                  ->first();

        $old_attributes = [
            'name' => 'Old Value',
            'reserve_price' => 1200,
        ];
        $new_attributes = [
            'name' => 'New Value',
            'reserve_price' => 1500,
        ];

        return template('Auction/emails/client_report_lot_update.twig', [
            'lot' => $lot,
            'old_attributes' => $old_attributes,
            'new_attributes' => $new_attributes,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function clientReportMemberCreatedExample()
    {
        $member = AuctionMember::latest()->first();

        return template('Auction/emails/client_report_member_created.twig', [
            'member' => $member,
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function paidSeller()
    {
        $lot_list = Lot::query()
            ->whereHas('seller_payout', function ($payout_query) {
                $payout_query->whereNotNull('payout_made_at');
    })                       
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $member = $lot_list->first()->seller;

        return template('Auction/emails/paid_seller.twig', [
            'lots' => $lot_list,
            'member' => $member,
            'seller_receipt_url' => config('app.url') . '/members/my-lots/' . $lot_list->first()->lot_id . '/receipt',
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function notPaidReminder()
    {
        $lot_list = Lot::query()
                       ->where('status', Lot\Status::SOLD)
                       ->where('buyer_id', '>', 0)
                       ->where('ends_at', 'like', Carbon::now()->subDays(2)->format('Y-m-d%'))
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->buyer_id;
        })
                             ->first();

        $member = $lot_list->first()->buyer;

        return template('Auction/emails/lots_not_paid_reminder.twig', [
            'lots' => $lot_list,
            'member' => $member,
            'purchase_url' => config('app.url') . '/purchase-lots',
        ]);
    }

    /**
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    protected function storageExpiringExample()
    {
        $auction = Auction::query()
                          ->past()
                          ->inRandomOrder()
                          ->first();

        $lot_list = Lot::query()
                       ->where('auction_id', $auction->id)
                       ->where('status', '!=', Lot\Status::SHIPPED)
                       ->get();

        if ($lot_list->count() === 0) {
            $lot_list = Lot::query()
                           ->get();
        }

        $lot_list = $lot_list->groupBy(function ($lot) {
            return $lot->seller_id;
        })
                             ->first();

        $seller = $lot_list->first()->seller;
        return template('Auction/emails/storage_expiring.twig', [
            'lots' => $lot_list,
            'member' => $seller,
        ]);
    }

    /**
     * Check if request comes from populate script
     * Used to avoid email spam on seeder
     *
     * @return bool
     */
    public static function isPopulateScript()
    {
        return request()->getPathInfo() === '/admin/auction/populate';
    }
    
}