<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use Illuminate\Http\Request;

/**
 * Trait FilterOverrides
 *
 * @package Mtc\Modules\Auction\Classes\Http\Controllers\Admin
 */
trait  FilterOverrides
{
    /**
     * Check if request has attributes that are overriding filters
     *
     * @param Request $request
     * @return bool
     */
    protected function hasFilterOverrides(Request $request)
    {
        return !empty(collect($request->input())->intersect(static::$override_filters));
    }

    /**
     * Store the session overrides and redirect to a page without these overrides in url
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    protected function processRequestOverrides(Request $request)
    {
        $_SESSION['filter_overrides'] = collect($request->input())->intersect(static::$override_filters);
        return redirect()->to($request->url());
    }

    /**
     * Get the stored overrides for filter
     *
     * @return array
     */
    protected function getOverrides()
    {
        $overrides = $_SESSION['filter_overrides'] ?? [];
        unset($_SESSION['filter_overrides']);
        return $overrides;
    }
}