<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use CustomFieldsHelper;
use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Auction\CustomField;
use Mtc\Shop\Http\Requests\CustomFieldRequest;
use Mtc\Taxonomies\Taxonomy;

class LotCustomFieldController extends Controller
{
    /**
     * List Colour Map Entries
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $this->page_meta['title'] = 'Manage Custom Fields';

        return template('Auction/admin/lots/custom-fields/index.twig', [
            'page_meta' => $this->page_meta,
            'custom_fields' => CustomField::all(),
        ]);
    }

    public function create(CustomField $custom_field)
    {
        $this->page_meta['title'] = 'Create Custom Field';
        return template('Auction/admin/lots/custom-fields/edit.twig', [
            'page_meta' => $this->page_meta,
            'field' => $custom_field,
            'types' => CustomField::$field_types,
            'lists' => Taxonomy::query()
                ->whereIsRoot()
                ->pluck('name', 'id')
        ]);
    }

    public function store(CustomFieldRequest $request, CustomField $custom_field)
    {
        $field_type = $request->input('type') === 'textarea' ? 'textarea' : 'text';
        $custom_field->addColumn($request->input('database_field'), $field_type);

        $field = CustomField::query()->create($request->input());
        session()->flash('success', 'Field Created');
        return redirect(route('admin.lots.custom-fields.edit', $field->id));
    }

    public function edit(CustomField $custom_field)
    {
        $this->page_meta['title'] = 'Edit Custom Field';
        return template('Auction/admin/lots/custom-fields/edit.twig', [
            'page_meta' => $this->page_meta,
            'field' => $custom_field,
            'types' => CustomField::$field_types,
            'lists' => Taxonomy::query()
                ->whereIsRoot()
                ->pluck('name', 'id')
        ]);
    }

    public function update(CustomFieldRequest $request, CustomField $custom_field)
    {
        $custom_field->fill($request->input());

        if ($custom_field->isDirty('database_field')) {
            $custom_field->renameColumn(
                $custom_field->getOriginal('database_field'),
                $custom_field->database_field
            );
        }

        $custom_field->save();
        session()->flash('success', 'Field updated');
        return redirect(route('admin.lots.custom-fields.edit', $custom_field->id));
    }

    public function destroy(CustomField $custom_field)
    {
        $custom_field->delete();
        session()->flash('success', 'Field removed');
        return redirect(route('admin.lots.custom-fields.index'));
    }

    public function forProduct(Request $request)
    {
        $set_id = 0;
        if ($request->has('category_id')) {
            $set_id = CustomFieldsHelper::getCategorySet($request->input('category_id'));
        }
        $custom = (new \Item($request->input('item_id')))->custom;

        if ($set_id == 0) {
            $set_id = CustomFieldsHelper::getDefaultSet();
        }

        return CustomFieldsHelper::displaySet($set_id, 'items', $custom)
            . '<input type="hidden" name="custom_field_set_id" value="' . (int) $set_id . '" />'
        ;
    }
}
