<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Auction\CustomField;
use Mtc\Auction\CustomFieldSet;
use Mtc\Shop\Http\Requests\CustomFieldRequest;

class LotCustomFieldSetController extends Controller
{
    /**
     * List Colour Map Entries
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $this->page_meta['title'] = 'Manage Custom Field Sets';

        return template('Auction/admin/lots/custom-field-sets/index.twig', [
            'page_meta' => $this->page_meta,
            'sets' => CustomFieldSet::all(),
        ]);
    }

    public function create(CustomFieldSet $custom_field_set)
    {
        $this->page_meta['title'] = 'Create Custom Field Set';
        return template('Auction/admin/lots/custom-field-sets/edit.twig', [
            'page_meta' => $this->page_meta,
            'set' => $custom_field_set,
        ]);
    }

    public function store(Request $request, CustomFieldSet $custom_field_set)
    {
        $validated = $this->validate($request, [
            'name' => 'required',
            'default' => 'sometimes',
        ]);
        $custom_field_set->fill($validated)->save();
        session()->flash('success', 'Set Created');
        return redirect(route('admin.lots.custom-field-sets.edit', $custom_field_set->id));
    }

    public function edit(CustomFieldSet $custom_field_set)
    {
        $this->page_meta['title'] = 'Edit Custom Field';
        return template('Auction/admin/lots/custom-field-sets/edit.twig', [
            'page_meta' => $this->page_meta,
            'set' => $custom_field_set,
            'fields' => CustomField::all(),
            'set_fields' => $custom_field_set->customFields->keyBy('id'),
        ]);
    }

    public function update(Request $request, CustomFieldSet $custom_field_set)
    {
        $custom_field_set->fill($request->input())->save();
        $fields = collect($request->input('fields', []))
            ->filter(function ($field) {
                return $field['enabled'] == 1;
            })
            ->map(function ($field) {
                unset($field['enabled']);
                return $field;
            })
            ->toArray();
        
        $custom_field_set->customFields()->sync($fields);
        
        session()->flash('success', 'Set updated');
        return redirect(route('admin.lots.custom-field-sets.edit', $custom_field_set->id));
    }

    public function destroy(CustomFieldSet $custom_field_set)
    {
        $custom_field_set->delete();
        session()->flash('success', 'Set removed');
        return redirect(route('admin.lots.custom-field-sets.index'));
    }
    
    public function loadFields(Request $request, CustomFieldSet $custom_field_set){
        $fields = $custom_field_set->customFields;
        $fields_formatted = [];
        foreach ($fields as $field){
            $fields_formatted[] =[
                'label' => $field->name,
                'type' => $field->type,
                'field' => $field->database_field,
            ];
        }
        if($request->wantsJson()){
            return [
                'success' => true,
                'custom_fields'     => $fields_formatted,
            ];
        }
        //TODO - Normal Response
    }
}
