<?php

namespace Mtc\Auction\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Auction\PriceTrend;
use Mtc\Auction\PriceTrendEntry;

class PriceTrendEntryController extends Controller
{
    public function index(Request $request)
    {
        
    }
    
    public function create(Request $request)
    {
        $this->page_meta['title'] = 'Create Price Trend Entry';
        return template('Auction/admin/price_trends_entries/edit.twig', [
            'price_trend_sources' => PriceTrendEntry::query()->get()->mapWithKeys(function ($price_trend_entry, $key){
                return [$price_trend_entry->source => $price_trend_entry->source];
            })->toArray(),
            'page_meta' => $this->page_meta,
            'price_trends' => PriceTrend::query()->get()->mapWithKeys(function ($price_trend, $key){
                return [$price_trend->id => $price_trend->catalogued_lot_name];
            })->toArray()
        ]);
    }
    
    public function edit(Request $request, PriceTrendEntry $priceTrendEntry)
    {
        $this->page_meta['title'] = 'Create Price Trend Entry';
        return template('Auction/admin/price_trends_entries/edit.twig', [
            'price_trend_sources' => array_merge(['' => 'Select a source'], PriceTrendEntry::query()->get()->mapWithKeys(function ($price_trend_entry, $key){
                return [$price_trend_entry->source => $price_trend_entry->source];
            })->toArray()),
            'page_meta' => $this->page_meta,
            'price_trend_entry' => $priceTrendEntry,
        ]);
    }
    
    public function store(Request $request)
    {
        $validated = $this->validate($request, [
            'price_trend_id' => 'required',
            'source' => 'required',
            'auction_date' => 'required|date',
            'amount' => 'required|numeric',
        ]);

        $price_trend = new PriceTrendEntry();
        $price_trend->fill($validated);
        $price_trend->save();

        session()->flash('success', 'Price Trend Created');
        return redirect()->to("/admin/price-trends-entries/{$price_trend->id}/edit");
    }
    
    /*public function update(Request $request, PriceTrendEntry $priceTrendEntry)
    {
        $this->page_meta['title'] = 'Create Price Trend';
        return template('Auction/admin/price_trends_entries/edit.twig', [
            'price_trend_sources' => array_merge(['' => 'Select a source'], PriceTrendEntry::query()->get()->mapWithKeys(function ($price_trend_entry, $key){
                return [$price_trend_entry->source => $price_trend_entry->source];
            })->toArray()),
            'page_meta' => $this->page_meta,
            'price_trend_entry' => $priceTrendEntry,
        ]);
    }*/

    /**
     * Delete a Price Trend
     *
     * @param $price_trend_id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($price_trend_entry_id)
    {
        $price_trend_entry = PriceTrendEntry::query()->find($price_trend_entry_id);
        if ($price_trend_entry) {
            $price_trend_entry->delete();
            session()->flash('success', 'Price Trend Entry Removed');
        }
        return redirect()->back();
    }
}