<?php

namespace Mtc\Auction\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Auction\Auction;
use Spatie\IcalendarGenerator\Components\Calendar;
use Spatie\IcalendarGenerator\Components\Event;
use Spatie\IcalendarGenerator\Components\Timezone;

class AuctionCalendarController
{
    /**
     * Browse page
     *
     * @param Request $request
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Syntax
     */
    public function index(Request $request)
    {
        $words        = preg_split("/[\s,_-]+/", config('app.name'));
        $site_acronym = '';
        foreach ($words as $w) {
            $site_acronym .= mb_substr($w, 0, 1);
        }

        $timezone = Timezone::create(config('app.timezone'));
        

        $calendar = Calendar::create()
                            ->name(config('app.name') . ' Auction Schedule')
                            ->description('All '
                                          . config('app.name')
                                          . ' auctions currently scheduled. Includes past auctions')
            ->timezone($timezone);

        $events = [];
        
        Auction::query()
               ->get()
               ->each(function ($auction) use ($calendar, $site_acronym) {
                   $starting_event = Event::create()
                                 ->name($auction->name . ' - Auction Starts')
                                 ->description($auction->content ?? '')
                                 ->uniqueIdentifier($site_acronym . $auction->id . 'START')
                                 ->createdAt($auction->created_at)
                                 ->startsAt($auction->starts_at)
                                 ->endsAt($auction->starts_at->addHour())
                   ;
                   
                   $ending_event = Event::create()
                                 ->name($auction->name . ' - Auction Ends')
                                 ->description($auction->content ?? '')
                                 ->uniqueIdentifier($site_acronym . $auction->id . 'END')
                                 ->createdAt($auction->created_at)
                                 ->startsAt(($auction->ends_at_original) ? $auction->ends_at_original->subHour() : $auction->ends_at->subHour())
                                 ->endsAt($auction->ends_at)
                   ;
                   //$events[] = $event;
                   $calendar->event($starting_event);
                   $calendar->event($ending_event);
               });

        //$calendar->event($events);

        echo ($calendar->get());
    }
}